/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class JRTFilesystemURIHandlerFix {
    public static void apply() {
        if (JRTFilesystemURIHandlerFix.requireJRTURIHander()) {
            URIConverter.INSTANCE.getURIHandlers().add(0, (Object)new JRTURIHandler());
            JRTFilesystemURIHandlerFix.apply(JRTFilesystemURIHandlerFix.getSharedDomain().getResourceSet());
        }
    }

    public static void apply(ResourceSet rs) {
        if (JRTFilesystemURIHandlerFix.requireJRTURIHander()) {
            rs.getURIConverter().getURIHandlers().add(0, (Object)new JRTURIHandler());
        }
    }

    protected static boolean requireJRTURIHander() {
        FileSystem jrtFileSystem = FileSystems.getFileSystem(java.net.URI.create("jrt:/"));
        Path classFilePath = jrtFileSystem.getPath("modules", "java.base", "java/lang/Object.class");
        java.net.URI classFileURI = classFilePath.toUri();
        try {
            URL url = new URL(classFileURI.toString());
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            inputStream.close();
            return false;
        }
        catch (Throwable exception) {
            return true;
        }
    }

    protected static TransactionalEditingDomain getSharedDomain() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("com.yakindu.sct.domain");
    }

    public static class JRTURIHandler
    extends FileURIHandlerImpl {
        FileSystem jrtFileSystem;

        public boolean canHandle(URI uri) {
            return uri.scheme().equals("jrt");
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            return Files.newInputStream(this.toPath(uri), new OpenOption[0]);
        }

        public boolean exists(URI uri, Map<?, ?> options) {
            return Files.isReadable(this.toPath(uri));
        }

        protected Path toPath(URI uri) {
            return this.fileSystem().getPath(uri.path(), new String[0]);
        }

        protected FileSystem fileSystem() {
            if (this.jrtFileSystem == null) {
                this.jrtFileSystem = FileSystems.getFileSystem(java.net.URI.create("jrt:/"));
            }
            return this.jrtFileSystem;
        }
    }
}

