/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.python;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Parameter;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.python.files.PackageInit;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.python.PythonSubchartInitializer;
import com.yakindu.sctunit.generator.python.extensions.CallbackExtensions;
import com.yakindu.sctunit.generator.python.extensions.JUnitTest;
import com.yakindu.sctunit.generator.python.extensions.NamingExtensions;
import com.yakindu.sctunit.generator.python.extensions.PythonStatementExtensions;
import com.yakindu.sctunit.generator.python.extensions.PythonVirtualTimerExtensions;
import com.yakindu.sctunit.generator.python.extensions.UnittestMockingExtensions;
import com.yakindu.sctunit.generator.python.features.PythonSCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class PythonSCTUnitGenerator
implements ISCTUnitGenerator {
    public static final String SCTUNIT_INFERRER = "com.yakindu.sctunit.generator.python.PythonSCTUnitGenerator.typeInferrer";
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    @Extension
    private NamingExtensions _namingExtensions;
    @Inject
    @Extension
    private PythonStatementExtensions _pythonStatementExtensions;
    @Inject
    @Extension
    private UnittestMockingExtensions mockExt;
    @Inject
    @Extension
    private CallbackExtensions _callbackExtensions;
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    @Inject
    @Extension
    private PythonSCTUnitGenmodelEntries _pythonSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private PythonVirtualTimerExtensions timer;
    @Inject
    @Extension
    private JUnitTest jUnitTest;
    @Inject
    @Extension
    private PythonSubchartInitializer _pythonSubchartInitializer;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private StringHelper _stringHelper;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private PackageInit _packageInit;
    private GeneratorEntry entry;

    public void generate(GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _needsTimer;
        this.entry = entry;
        TestPackage testPackage = this.getTestPackage(entry);
        String fileName = this.getFileName(testPackage).toLowerCase();
        SCTUnitElement element = this._baseNavigationExtensions.getSCTUnitElement(testPackage);
        CharSequence content = this.toCode(element);
        this.generateJUnitWrapper(entry, testPackage, fsa);
        if (element instanceof SCTUnitClass && (_needsTimer = this._pythonSubchartInitializer.needsTimer(((SCTUnitClass)element).getStatechart()))) {
            this.timer.generate(entry, fsa, "/vtimer/virtual_timer.py");
            this._packageInit.generatePyPackageInit(fsa, "/vtimer", "LIBRARY_TARGET_FOLDER", entry);
        }
        fsa.generateFile(fileName, content);
    }

    protected void generateJUnitWrapper(GeneratorEntry entry, TestPackage testPackage, IFileSystemAccess fsa) {
        boolean _isJUnitWrapper = this._pythonSCTUnitGenmodelEntries.isJUnitWrapper(entry);
        if (_isJUnitWrapper) {
            String targetProject = this._iCoreLibraryHelper.getTargetProjectValue(entry).getStringValue();
            this.jUnitTest.generateJUnitTest(testPackage, fsa, this._stringHelper.toPath(targetProject));
        }
    }

    protected String getFileName(TestPackage it) {
        StringConcatenation _builder = new StringConcatenation();
        String _py = this._naming.py(this._namingExtensions.testClassName(this._baseNavigationExtensions.getSCTUnitElement(it)));
        _builder.append(_py);
        return _builder.toString().toLowerCase();
    }

    protected boolean containsTestUnitsFromMultiplePackages(SCTUnitSuite suite) {
        String comperator = this._namingExtensions.statechartName(((SCTUnitClass[])Conversions.unwrapArray((Object)this._baseNavigationExtensions.getSCTUnitClasses(suite), SCTUnitClass.class))[0]);
        Iterable _sCTUnitClasses = this._baseNavigationExtensions.getSCTUnitClasses(suite);
        for (SCTUnitClass uc : _sCTUnitClasses) {
            boolean _not;
            boolean _equals = this._namingExtensions.statechartName(uc).equals(comperator);
            boolean bl = _not = !_equals;
            if (!_not) continue;
            return true;
        }
        return false;
    }

    protected TestPackage getTestPackage(GeneratorEntry entry) {
        EObject _eContainer = entry.getElementRef().eContainer();
        return (TestPackage)_eContainer;
    }

    protected CharSequence _toCode(SCTUnitSuite it) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._pythonSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Suite: ");
        String _testClassClassName = this._namingExtensions.testClassClassName((SCTUnitElement)it);
        _builder.append(_testClassClassName);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _containsTestUnitsFromMultiplePackages = this.containsTestUnitsFromMultiplePackages(it);
        if (_containsTestUnitsFromMultiplePackages) {
            _builder.append("import glob, string");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("import unittest");
        _builder.newLine();
        _builder.append("import warnings");
        _builder.newLine();
        _builder.newLine();
        boolean _containsTestUnitsFromMultiplePackages_1 = this.containsTestUnitsFromMultiplePackages(it);
        if (_containsTestUnitsFromMultiplePackages_1) {
            CharSequence _createSuiteBodyMultiplePackages = this.createSuiteBodyMultiplePackages(it);
            _builder.append((Object)_createSuiteBodyMultiplePackages);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _createSuiteBodySinglePackage = this.createSuiteBodySinglePackage(it);
            _builder.append((Object)_createSuiteBodySinglePackage);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    protected CharSequence createSuiteBodySinglePackage(SCTUnitSuite it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        Iterable _sCTUnitClasses = this._baseNavigationExtensions.getSCTUnitClasses(it);
        for (SCTUnitClass group : _sCTUnitClasses) {
            _builder.append("from ");
            String _lowerCase = this._namingExtensions.testClassName((SCTUnitElement)group).toLowerCase();
            _builder.append(_lowerCase);
            _builder.append(" import ");
            String _testClassClassName = this._namingExtensions.testClassClassName((SCTUnitElement)group);
            _builder.append(_testClassClassName);
            _builder.append("TestCase");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("def run_suite():");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("suite = unittest.TestSuite()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("result = unittest.TestResult()");
        _builder.newLine();
        Iterable _sCTUnitClasses_1 = this._baseNavigationExtensions.getSCTUnitClasses(it);
        boolean _hasElements = false;
        for (SCTUnitClass group_1 : _sCTUnitClasses_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            _builder.append("suite.addTest(unittest.makeSuite(");
            String _testClassClassName_1 = this._namingExtensions.testClassClassName((SCTUnitElement)group_1);
            _builder.append(_testClassClassName_1, "\t");
            _builder.append("TestCase))");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("runner = unittest.TextTestRunner(verbosity=2)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("print(runner.run(suite))");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("run_suite()");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence createSuiteBodyMultiplePackages(SCTUnitSuite it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# testcases listed / specified in SCT Unit file:");
        _builder.newLine();
        _builder.append("target_tests = [\\");
        _builder.newLine();
        Iterable _sCTUnitClasses = this._baseNavigationExtensions.getSCTUnitClasses(it);
        for (SCTUnitClass group : _sCTUnitClasses) {
            _builder.append("\t");
            _builder.append("'");
            String _statechartName = this._namingExtensions.statechartName(group);
            _builder.append(_statechartName, "\t");
            _builder.append(".tests.");
            String _testClassName = this._namingExtensions.testClassName((SCTUnitElement)group);
            _builder.append(_testClassName, "\t");
            _builder.append("',\\");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("# recursive search for all testcases in current directory:");
        _builder.newLine();
        _builder.append("found_tests_raw = glob.glob('**/test_*.py', recursive=True)");
        _builder.newLine();
        _builder.append("found_tests = [test_file[0:len(test_file)-3].replace('\\\\','.') for test_file in found_tests_raw]");
        _builder.newLine();
        _builder.append("# match testcases found with user specified testcases:");
        _builder.newLine();
        _builder.append("testcases = set(target_tests).intersection(found_tests)");
        _builder.newLine();
        _builder.append("print('Number of TestCases specified by user: ', len(target_tests))");
        _builder.newLine();
        _builder.append("print('Number of TestCases found by search: ', len(found_tests))");
        _builder.newLine();
        _builder.append("print('Number of matching TestCases: ', len(testcases))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("with warnings.catch_warnings(record=False):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("suites = [unittest.defaultTestLoader.loadTestsFromName(test_file) for test_file in testcases]");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("test_suite = unittest.TestSuite(suites)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("test_runner = unittest.TextTestRunner(verbosity=2).run(test_suite)");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence createStatemachineImports(SCTUnitElement it, GeneratorEntry entry) {
        boolean _needsTimer;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import sys");
        _builder.newLine();
        _builder.append("import os");
        _builder.newLine();
        if (it instanceof SCTUnitClass) {
            _builder.append("from ");
            String _dot = this._stringHelper.dot(this._pythonSCTUnitGenmodelEntries.getStatechartBasePackage(entry), this._namingExtensions.statemachineClassName((SCTUnitClass)it));
            _builder.append(_dot);
            _builder.append(" import ");
            String _firstUpper = StringExtensions.toFirstUpper((String)this._namingExtensions.statechartName((SCTUnitClass)it));
            _builder.append(_firstUpper);
            _builder.newLineIfNotEmpty();
        }
        SCTUnitClass _sCTUnitClass = this._baseNavigationExtensions.getSCTUnitClass((EObject)it);
        Statechart _statechart = null;
        if (_sCTUnitClass != null) {
            _statechart = _sCTUnitClass.getStatechart();
        }
        Set _keySet = this._pythonSubchartInitializer.getSubchartImports(_statechart).keySet();
        for (Statechart subchart : _keySet) {
            _builder.append("from ");
            String _dot_1 = this._stringHelper.dot(this._pythonSCTUnitGenmodelEntries.getStatechartBasePackage(entry, subchart), this._naming.statemachineClassName((Notifier)subchart));
            _builder.append(_dot_1);
            _builder.append(" import ");
            String _statemachineName = this._naming.statemachineName((Object)subchart);
            _builder.append(_statemachineName);
            _builder.newLineIfNotEmpty();
        }
        SCTUnitClass _sCTUnitClass_1 = this._baseNavigationExtensions.getSCTUnitClass((EObject)it);
        Statechart _statechart_1 = null;
        if (_sCTUnitClass_1 != null) {
            _statechart_1 = _sCTUnitClass_1.getStatechart();
        }
        if (_needsTimer = this._pythonSubchartInitializer.needsTimer(_statechart_1)) {
            boolean _isCycleBased;
            _builder.append("from ");
            String _dot_2 = this._stringHelper.dot(this._pythonSCTUnitGenmodelEntries.getStatechartLibraryPackage(entry), "vtimer.virtual_timer");
            _builder.append(_dot_2);
            _builder.append(" import VirtualTimer");
            SCTUnitClass _sCTUnitClass_2 = this._baseNavigationExtensions.getSCTUnitClass((EObject)it);
            Statechart _statechart_2 = null;
            if (_sCTUnitClass_2 != null) {
                _statechart_2 = _sCTUnitClass_2.getStatechart();
            }
            if (_isCycleBased = this._statechartAnnotations.isCycleBased(_statechart_2)) {
                _builder.append(", CycleTimeEventTask");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))");
        _builder.newLine();
        return _builder;
    }

    protected List<Scope> getAllScopesToMock(SCTUnitClass it) {
        Functions.Function1 _function = it_1 -> {
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)this._sExecExtensions.operations(it_1));
            return !_isNullOrEmpty;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)it.getStatechart().getScopes(), (Functions.Function1)_function));
    }

    protected CharSequence _toCode(SCTUnitClass it) {
        try {
            StringConcatenation _xblockexpression = null;
            List<Scope> scopes = this.getAllScopesToMock(it);
            List uninitializedVariableDefinitions = IterableExtensions.toList((Iterable)EcoreUtil.copyAll((Collection)it.getVariableDefinitions()));
            Consumer<VariableDefinitionStatement> _function = it_1 -> {
                VariableDefinition _definition = it_1.getDefinition();
                _definition.setInitialValue(null);
            };
            uninitializedVariableDefinitions.forEach(_function);
            StringConcatenation _builder = new StringConcatenation();
            String _licenseText = this._pythonSCTUnitGenmodelEntries.getLicenseText(this.entry);
            _builder.append(_licenseText);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("import unittest");
            _builder.newLine();
            if (this.mockExt.isMockingRequired(it) || this.hasInternalOperation(it.getStatechart())) {
                _builder.append("from unittest import mock");
                _builder.newLine();
            }
            _builder.newLine();
            CharSequence _createStatemachineImports = this.createStatemachineImports((SCTUnitElement)it, this.entry);
            _builder.append((Object)_createStatemachineImports);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("# Unit TestCase for ");
            String _name = it.getStatechart().getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append("class ");
            String _testClassClassName = this._namingExtensions.testClassClassName((SCTUnitElement)it);
            _builder.append(_testClassClassName);
            _builder.append("TestCase(unittest.TestCase):");
            _builder.newLineIfNotEmpty();
            for (VariableDefinitionStatement variable : uninitializedVariableDefinitions) {
                _builder.append("\t");
                CharSequence _generate = this._pythonStatementExtensions.generate((TestStatement)variable);
                _builder.append((Object)_generate, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _setup = this.setup(it);
            _builder.append((Object)_setup, "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("def tearDown(self):");
            _builder.newLine();
            for (Scope scope : scopes) {
                _builder.append("\t\t");
                CharSequence _unsetOperationCallback = this._callbackExtensions.unsetOperationCallback(scope);
                _builder.append((Object)_unsetOperationCallback, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            if (this._statechartAnnotations.isCycleBased(it.getStatechart()) || this._pythonSubchartInitializer.isTimed(it.getStatechart())) {
                _builder.append("\t\t");
                _builder.append("self.timer_service.stop()");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("self.");
            String _statemachineReferenceName = this._namingExtensions.statemachineReferenceName();
            _builder.append(_statemachineReferenceName, "\t\t");
            _builder.append(".exit()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            List _sCTUnitOperations = this._baseNavigationExtensions.getSCTUnitOperations(it);
            for (SCTUnitOperation operation : _sCTUnitOperations) {
                _builder.append("\t");
                CharSequence _code = this.toCode(operation);
                _builder.append((Object)_code, "\t");
                _builder.newLineIfNotEmpty();
            }
            _xblockexpression = _builder;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence _toCode(SCTUnitOperation it) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        boolean _isTest = this._baseNavigationExtensions.isTest((EObject)it);
        if (_isTest) {
            this.mockExt.clearMockedOperations();
        }
        StringConcatenation _builder = new StringConcatenation();
        boolean _isIgnore = this._baseNavigationExtensions.isIgnore(it);
        if (_isIgnore) {
            _builder.append("@unittest.skip(\"Ignored. See related .sctunit file.\")");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("def ");
        boolean _isTest_1 = this._baseNavigationExtensions.isTest((EObject)it);
        if (_isTest_1) {
            _builder.append("test_");
        }
        CharSequence _methodName = this._namingExtensions.methodName(it);
        _builder.append((Object)_methodName);
        _builder.append("(self");
        boolean _isEmpty = it.getParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(", ");
        }
        CharSequence _generateParameter = this.generateParameter(it);
        _builder.append((Object)_generateParameter);
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateSideEffects = this.mockExt.generateSideEffects(this.mockExt.generateSideEffectList(it));
        _builder.append((Object)_generateSideEffects, "\t");
        _builder.newLineIfNotEmpty();
        EList _variableDefinitions = this._baseNavigationExtensions.getSCTUnitClass(it).getVariableDefinitions();
        for (VariableDefinitionStatement variable : _variableDefinitions) {
            _builder.append("\t");
            _builder.append("global ");
            String _identifier = this._naming.identifier((EObject)variable.getDefinition());
            _builder.append(_identifier, "\t");
            _builder.newLineIfNotEmpty();
        }
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getBody().getCode());
        if (_isNullOrEmpty) {
            _builder.append("\t");
            _builder.append("pass");
            _builder.newLine();
        }
        EList _code = it.getBody().getCode();
        for (TestStatement statement : _code) {
            _builder.append("\t");
            CharSequence _generate = this._pythonStatementExtensions.generate(statement);
            _builder.append((Object)_generate, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected List<Expression> _argumentExpressions(Expression it) {
        return null;
    }

    protected List<Expression> _argumentExpressions(ElementReferenceExpression it) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getExpressions());
        if (_isNullOrEmpty) {
            return Collections.emptyList();
        }
        return it.getExpressions();
    }

    protected List<Expression> _argumentExpressions(FeatureCall it) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getExpressions());
        if (_isNullOrEmpty) {
            return Collections.emptyList();
        }
        return it.getExpressions();
    }

    protected CharSequence _toCode(List<VariableDefinitionStatement> varDefs) {
        StringConcatenation _builder = new StringConcatenation();
        for (VariableDefinitionStatement varDef : varDefs) {
            CharSequence _code = this.toCode(varDef);
            _builder.append((Object)_code);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _toCode(VariableDefinitionStatement it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generate = this._pythonStatementExtensions.generate((TestStatement)it);
        _builder.append((Object)_generate);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected boolean hasInternalOperation(Statechart statechart) {
        boolean _hasOperations;
        InternalScope internalScope = null;
        EList _scopes = statechart.getScopes();
        for (Scope s : _scopes) {
            if (!(s instanceof InternalScope)) continue;
            internalScope = (InternalScope)s;
        }
        return internalScope != null && (_hasOperations = this._sExecExtensions.hasOperations(internalScope));
    }

    protected CharSequence setup(SCTUnitClass it) throws Exception {
        boolean _isTimed;
        boolean _isCycleBased;
        StringConcatenation _xblockexpression = null;
        List<Scope> scopes = this.getAllScopesToMock(it);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def setUp(self):");
        _builder.newLine();
        for (Scope scope : scopes) {
            _builder.append("\t");
            CharSequence _defaultMock = this.mockExt.defaultMock(scope);
            _builder.append((Object)_defaultMock, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("self.");
        String _statemachineReferenceName = this._namingExtensions.statemachineReferenceName();
        _builder.append(_statemachineReferenceName, "\t");
        _builder.append(" = ");
        String _firstUpper = StringExtensions.toFirstUpper((String)this._namingExtensions.statechartName(it));
        _builder.append(_firstUpper, "\t");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        boolean _needsTimer = this._pythonSubchartInitializer.needsTimer(it.getStatechart());
        if (_needsTimer) {
            _builder.append("\t");
            _builder.append("self.timer_service = VirtualTimer(");
            long _cyclePeriod = this._pythonStatementExtensions.getCyclePeriod(it);
            _builder.append((Object)_cyclePeriod, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        if (_isCycleBased = this._statechartAnnotations.isCycleBased(it.getStatechart())) {
            _builder.append("\t");
            _builder.append("self.timer_service.schedule_periodical_task(CycleTimeEventTask(self.");
            String _statemachineReferenceName_1 = this._namingExtensions.statemachineReferenceName();
            _builder.append(_statemachineReferenceName_1, "\t");
            _builder.append("), ");
            long _cyclePeriod_1 = this._pythonStatementExtensions.getCyclePeriod(it);
            _builder.append((Object)_cyclePeriod_1, "\t");
            _builder.append(", ");
            long _cyclePeriod_2 = this._pythonStatementExtensions.getCyclePeriod(it);
            _builder.append((Object)_cyclePeriod_2, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        if (_isTimed = this._pythonSubchartInitializer.isTimed(it.getStatechart())) {
            _builder.append("\t");
            _builder.append("self.");
            String _statemachineReferenceName_2 = this._namingExtensions.statemachineReferenceName();
            _builder.append(_statemachineReferenceName_2, "\t");
            _builder.append(".timer_service = self.timer_service");
            _builder.newLineIfNotEmpty();
        }
        for (Scope scope_1 : scopes) {
            _builder.append("\t");
            String _mockOperationCallbacks = this.mockExt.mockOperationCallbacks(scope_1);
            _builder.append(_mockOperationCallbacks, "\t");
            _builder.newLineIfNotEmpty();
        }
        EList _variableDefinitions = it.getVariableDefinitions();
        for (VariableDefinitionStatement variable : _variableDefinitions) {
            _builder.append("\t");
            _builder.append("global ");
            String _identifier = this._naming.identifier((EObject)variable.getDefinition());
            _builder.append(_identifier, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generate = this._pythonStatementExtensions.generate((TestStatement)variable);
            _builder.append((Object)_generate, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        String _subchartInitSequence = this._pythonSubchartInitializer.getSubchartInitSequence(it.getStatechart());
        _builder.append(_subchartInitSequence, "\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateParameter(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _identifier = this._naming.identifier((EObject)param);
            _builder.append(_identifier);
        }
        return _builder;
    }

    @XbaseGenerated
    public CharSequence toCode(Object it) {
        if (it instanceof SCTUnitClass) {
            return this._toCode((SCTUnitClass)it);
        }
        if (it instanceof SCTUnitSuite) {
            return this._toCode((SCTUnitSuite)it);
        }
        if (it instanceof SCTUnitOperation) {
            return this._toCode((SCTUnitOperation)it);
        }
        if (it instanceof VariableDefinitionStatement) {
            return this._toCode((VariableDefinitionStatement)it);
        }
        if (it instanceof List) {
            return this._toCode((List)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected List<Expression> argumentExpressions(Expression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._argumentExpressions((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._argumentExpressions((FeatureCall)it);
        }
        if (it != null) {
            return this._argumentExpressions(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

