/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.python.extensions;

import com.google.inject.Inject;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.python.features.PythonSCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class PythonVirtualTimerExtensions {
    @Inject
    @Extension
    private PythonSCTUnitGenmodelEntries _pythonSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    private GeneratorEntry entry;

    public void generate(GeneratorEntry entry, IFileSystemAccess fsa, String targetPath) {
        this.entry = entry;
        TestPackage testPackage = this._baseNavigationExtensions.getTestPackage(entry);
        CharSequence content = this.toCode(this._baseNavigationExtensions.getSCTUnitElement(testPackage));
        fsa.generateFile(targetPath, "LIBRARY_TARGET_FOLDER", content);
    }

    protected CharSequence toCode(SCTUnitElement it) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._pythonSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import queue");
        _builder.newLine();
        _builder.append("import functools");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class VirtualTimer:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"A `virtual`timer that actually doesn't use real time.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Instead all the processing is done via PriorityQueue.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self, cycle_period=0):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.stop_time = 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.current_time = 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.cycle_period = cycle_period");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.schedule_count = 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.tasks = queue.PriorityQueue()");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def time_leap(self, ms):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.stop_time = self.current_time + ms");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.process_tasks()");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def cycle_leap(self, cycles):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for _ in range(cycles):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("cycle_task = self.get_cycle_task()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if cycle_task is not None:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.time_leap(cycle_task.next_execution_time - self.current_time)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def set_timer(self, callback, event_id, duration, is_periodical):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if duration <= 0:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("duration = 1");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("time_event_task = VirtualTimeEventTask(callback, event_id)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if is_periodical:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.schedule_periodical_task(time_event_task, duration, duration)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.schedule_task(time_event_task, duration)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def unset_timer(self, callback, event_id):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task_found = self.get_task(callback, event_id)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if task_found is not None:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("task_found.cancel()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.put(task_found)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return True");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return False");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def schedule_task(self, task, interval):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.interval = interval");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.schedule_internal(task, self.current_time + interval, -1)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def schedule_periodical_task(self, task, interval, period):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.schedule_internal(task, self.current_time + interval, period)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def schedule_internal(self, task, time, period):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.next_execution_time = time");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.period = period");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.schedule_order = self.schedule_count");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.schedule_count += 1");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.tasks.put(task)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def process_tasks(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("process = not self.tasks.empty()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while not self.tasks.empty() and process:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("task = self.tasks.get()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if task is None:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("break");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if task.is_canceled:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if task.next_execution_time <= self.stop_time:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.current_time = task.next_execution_time");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if task.period > -1:");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("self.schedule_periodical_task(task, task.period, task.period)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("task.run()");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.tasks.put(task)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("self.current_time = self.stop_time");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("process = False");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def stop(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("temp_task_list = []");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for _ in range(self.tasks.qsize()):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("temp = self.tasks.get()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("temp.cancel()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("temp_task_list.append(temp)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for task in temp_task_list:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.put(task)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def cancel(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for _ in range(self.tasks.qsize()):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.get()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def get_task(self, callback, event_id):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"This method could be optimized in terms of performance.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("# find task");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task_found = None");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("temp_task_list = []");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for _ in range(self.tasks.qsize()):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("temp = self.tasks.get()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("temp_task_list.append(temp)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if not isinstance(temp, VirtualTimeEventTask):");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if not callback == temp.callback:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if temp.event_id == event_id:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("task_found = temp");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("break");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("# add all removed tasks to queue");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for task in temp_task_list:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.put(task)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return task_found");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def get_cycle_task(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"This method could be optimized in terms of performance.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("# find task");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task_found = None");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("temp_task_list = []");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for _ in range(self.tasks.qsize()):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("temp = self.tasks.get()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("temp_task_list.append(temp)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.task_done()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if isinstance(temp, CycleTimeEventTask):");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("task_found = temp");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("break");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("# add all removed tasks to queue");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for task in temp_task_list:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.tasks.put(task)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return task_found");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("@functools.total_ordering");
        _builder.newLine();
        _builder.append("class VirtualTimeTask:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.next_execution_time = 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.interval = 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.period = -1");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.schedule_order = 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.is_canceled = False");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __eq__(self, other):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return (self.next_execution_time == other.next_execution_time)\\");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("and (isinstance(other, CycleTimeEventTask) and isinstance(self, CycleTimeEventTask))\\");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("and (self.period == other.period)\\");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("and (self.schedule_order == other.schedule_order)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __lt__(self, other):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if self.next_execution_time != other.next_execution_time:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return (self.next_execution_time - other.next_execution_time) < 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if isinstance(other, CycleTimeEventTask) and not isinstance(self, CycleTimeEventTask):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return True");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if not isinstance(other, CycleTimeEventTask) and isinstance(self, CycleTimeEventTask):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return False");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if self.period != other.period:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return (self.period - other.period) < 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return (self.schedule_order - other.schedule_order) < 0");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def cancel(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.is_canceled = True");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class VirtualTimeEventTask(VirtualTimeTask):");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self, callback, event_id):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.callback = callback");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.event_id = event_id");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super().__init__()");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def run(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.callback.time_elapsed(self.event_id)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("class CycleTimeEventTask(VirtualTimeTask):");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self, statemachine):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.statemachine = statemachine");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super().__init__()");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def run(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.statemachine.run_cycle()");
        _builder.newLine();
        return _builder;
    }
}

