/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.coverage.ui.view;

import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sctunit.coverage.io.JSONToMeasurement;
import com.yakindu.sctunit.coverage.persistence.CoverageStore;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import com.yakindu.sctunit.simulation.core.launch.ISCTUnitLaunchParameters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Consumer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class CoveragePartListener
implements IPartListener,
ISCTUnitLaunchParameters {
    Consumer<Measurement> onInputChanged;
    JSONToMeasurement jsonToMeasurement = null;

    public CoveragePartListener(Consumer<Measurement> onInputChanged) {
        this.onInputChanged = onInputChanged;
    }

    public void partOpened(IWorkbenchPart part) {
        String filePath;
        if (part instanceof TextEditor && (filePath = ((FileEditorInput)((TextEditor)part).getEditorInput()).getPath().toString()).endsWith(".cov")) {
            Display.getDefault().asyncExec(() -> {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.closeEditor((IEditorPart)((TextEditor)part), false);
            });
            this.useMeasurementFromFile(new File(filePath));
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof XtextEditor) {
            String elementName = "";
            ILaunchConfiguration coverageConfig = null;
            String filePath = ((FileEditorInput)((XtextEditor)part).getEditorInput()).getPath().toString();
            URI filePathURI = URI.createURI((String)filePath);
            String fileName = filePathURI.lastSegment().toString().replace(".sctunit", "");
            if (filePath.endsWith(".sctunit")) {
                boolean hiddenFile = false;
                try {
                    coverageConfig = this.getCoverageLaunchConfiguration(fileName);
                    hiddenFile = coverageConfig != null ? coverageConfig.getAttribute("hideCoverageFiles", true) : false;
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                if (coverageConfig != null) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    IResource editorResource = ((XtextEditor)part).getResource();
                    URI uri = URI.createPlatformResourceURI((String)editorResource.getFullPath().toString(), (boolean)true);
                    Resource resource = resourceSet.getResource(uri, true);
                    TestPackage testPackage = (TestPackage)resource.getContents().stream().filter(x -> x instanceof TestPackage).toArray()[0];
                    SCTUnitElement unitElement = (SCTUnitElement)testPackage.getMember().get(0);
                    if (unitElement instanceof SCTUnitClass) {
                        Statechart st = ((SCTUnitClass)unitElement).getStatechart();
                        elementName = unitElement.getName();
                    } else if (unitElement instanceof SCTUnitSuite) {
                        elementName = ((SCTUnitSuite)unitElement).getName();
                    }
                    if (elementName == null) {
                        this.notifyInputChanged(null);
                    } else {
                        String workingFolder = this.getCurrentWorkingFolder(filePath);
                        File coverageFolder = new File(workingFolder);
                        if (coverageFolder.exists()) {
                            File[] files = coverageFolder.listFiles();
                            ArrayList<File> filteredFiles = new ArrayList<File>();
                            CoverageStore store = new CoverageStore();
                            File[] fileArray = files;
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                if (store.isCoverageFile(file.getName()) && file.getName().contains(elementName)) {
                                    filteredFiles.add(file);
                                }
                                ++n2;
                            }
                            File newestFile = this.searchForNewestFile(filteredFiles, hiddenFile);
                            if (newestFile == null) {
                                this.notifyInputChanged(null);
                            } else {
                                this.useMeasurementFromFile(newestFile);
                            }
                        }
                    }
                } else {
                    this.notifyInputChanged(null);
                }
            }
        }
    }

    protected void notifyInputChanged(Measurement m) {
        if (this.onInputChanged != null) {
            this.onInputChanged.accept(m);
        }
    }

    protected void useMeasurementFromFile(File file) {
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String fileContent = new String(bytes);
        this.jsonToMeasurement = new JSONToMeasurement(fileContent);
        Measurement measurement = this.jsonToMeasurement.generateMeasurement();
        this.notifyInputChanged(measurement);
    }

    protected ILaunchConfiguration getCoverageLaunchConfiguration(String fileName) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
        ILaunchConfiguration targetConfig = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
            if (launchConfig.getName().replace(".sctunit", "").equals(fileName)) {
                targetConfig = launchConfig;
            }
            ++n2;
        }
        return targetConfig;
    }

    protected String getCurrentWorkingFolder(String filePath) {
        URI uri = URI.createURI((String)filePath);
        URI workingFolder = uri.trimSegments(1);
        return workingFolder.toString() + "/";
    }

    protected File searchForNewestFile(ArrayList<File> files, boolean hiddenFile) {
        File newestFile = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        Date newestDate = null;
        for (File file : files) {
            String fileName = file.getName();
            String fileDateString = this.extractFileDateString(fileName);
            try {
                Date fileDate = dateFormat.parse(fileDateString);
                if (newestDate != null && !fileDate.after(newestDate)) continue;
                newestDate = fileDate;
                newestFile = file;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return newestFile;
    }

    private String extractFileDateString(String fileName) {
        int startIndex = fileName.startsWith(".") ? fileName.indexOf(46) + 1 : 0;
        int endIndex = fileName.indexOf(46, startIndex);
        return fileName.substring(startIndex, endIndex).replaceAll("[^0-9-]", "");
    }

    public JSONToMeasurement getJSONToMeasurement() {
        return this.jsonToMeasurement;
    }
}

