/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.ui.junit;

import com.google.common.collect.Maps;
import com.yakindu.sctunit.ui.SCTUnitActivator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.junit.ui.TestViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public class JUnitViewClickInterceptor
implements IStartup {
    protected WorkbenchListener listener = new WorkbenchListener();

    protected void checkPart(IWorkbenchPart part) {
        if (part instanceof TestRunnerViewPart) {
            TestViewer viewer = this.readField(part, "fTestViewer", TestViewer.class);
            TreeViewer treeViewer = this.readField(viewer, "fTreeViewer", TreeViewer.class);
            TableViewer tableViewer = this.readField(viewer, "fTableViewer", TableViewer.class);
            TypedListener treeListener = this.findSelctionListener((Widget)treeViewer.getTree(), TestViewer.class);
            TypedListener tableListener = this.findSelctionListener((Widget)tableViewer.getTable(), TestViewer.class);
            if (treeListener == null || tableListener == null) {
                return;
            }
            this.replaceListener((Widget)treeViewer.getTree(), treeListener, (SelectionListener)new SCTUnitSelectionListener(viewer, (StructuredViewer)treeViewer));
            this.replaceListener((Widget)tableViewer.getTable(), tableListener, (SelectionListener)new SCTUnitSelectionListener(viewer, (StructuredViewer)tableViewer));
        }
    }

    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                workbench.addWindowListener((IWindowListener)JUnitViewClickInterceptor.this.listener);
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        page.addPartListener((IPartListener)JUnitViewClickInterceptor.this.listener);
                        IViewReference[] iViewReferenceArray = page.getViewReferences();
                        int n5 = iViewReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IViewReference part = iViewReferenceArray[n6];
                            JUnitViewClickInterceptor.this.checkPart((IWorkbenchPart)part.getView(false));
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    protected TypedListener findSelctionListener(Widget provider, Class<?> declaringClass) {
        Listener[] listenerArray = provider.getListeners(13);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener o = listenerArray[n2];
            if (o instanceof TypedListener && ((TypedListener)o).getEventListener().getClass().getDeclaringClass() == declaringClass) {
                return (TypedListener)o;
            }
            ++n2;
        }
        return null;
    }

    protected void replaceListener(Widget provider, TypedListener oldListener, SelectionListener newListener) {
        provider.removeListener(13, (Listener)oldListener);
        provider.removeListener(14, (Listener)oldListener);
        provider.addListener(13, (Listener)new TypedListener((EventListener)newListener));
        provider.addListener(14, (Listener)new TypedListener((EventListener)newListener));
    }

    protected <T> T readField(Object owner, String fieldName, Class<T> type) {
        try {
            Field field = owner.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(owner);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static class SCTUnitSelectionListener
    extends SelectionAdapter {
        private StructuredViewer viewer;
        private TestViewer delegate;

        public SCTUnitSelectionListener(TestViewer delegate, StructuredViewer viewer) {
            this.delegate = delegate;
            this.viewer = viewer;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TestSuiteElement testSuite;
            String suiteURI;
            TestCaseElement testCase;
            String methodURI;
            Object testElement;
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof StructuredSelection && ((testElement = ((StructuredSelection)selection).getFirstElement()) instanceof TestCaseElement ? this.openInEditor(methodURI = (testCase = (TestCaseElement)testElement).getClassName()) : testElement instanceof TestSuiteElement && (suiteURI = this.getClassUri(testSuite = (TestSuiteElement)testElement)) != null && this.openInEditor(suiteURI))) {
                return;
            }
            try {
                Method method = this.delegate.getClass().getDeclaredMethod("handleDefaultSelected", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.delegate, new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        protected String getClassUri(TestSuiteElement suite) {
            if (suite.getChildren().length > 0) {
                if (suite.getChildren()[0] instanceof TestCaseElement) {
                    TestCaseElement testCase = (TestCaseElement)suite.getChildren()[0];
                    URI uri = URI.createURI((String)testCase.getClassName());
                    String classUri = uri.trimFragment().appendFragment(suite.getClassName()).toString();
                    return classUri;
                }
                if (suite.getChildren()[0] instanceof TestSuiteElement) {
                    TestSuiteElement childSuite = (TestSuiteElement)suite.getChildren()[0];
                    return this.getClassUri(childSuite);
                }
            }
            return null;
        }

        protected boolean openInEditor(String className) {
            URI uri;
            block3: {
                try {
                    uri = URI.createURI((String)className, (boolean)true);
                    if (URIConverter.INSTANCE.exists(uri, (Map)Maps.newHashMap())) break block3;
                    return false;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            IURIEditorOpener opener = (IURIEditorOpener)SCTUnitActivator.getInstance().getInjector("com.yakindu.sctunit.SCTUnit").getInstance(IURIEditorOpener.class);
            return opener.open(uri, true) != null;
        }
    }

    protected class WorkbenchListener
    implements IWindowListener,
    IPageListener,
    IPartListener {
        protected WorkbenchListener() {
        }

        public void pageClosed(IWorkbenchPage page) {
            page.removePartListener((IPartListener)JUnitViewClickInterceptor.this.listener);
        }

        public void pageOpened(IWorkbenchPage page) {
            page.addPartListener((IPartListener)JUnitViewClickInterceptor.this.listener);
        }

        public void partOpened(IWorkbenchPart part) {
            JUnitViewClickInterceptor.this.checkPart(part);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.addPageListener((IPageListener)JUnitViewClickInterceptor.this.listener);
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.removePageListener((IPageListener)JUnitViewClickInterceptor.this.listener);
        }

        public void pageActivated(IWorkbenchPage page) {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    }
}

