/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.TypeAlias;
import com.yakindu.base.types.TypeBuilder;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.commons.EmfUriUtil;
import com.yakindu.sct.commons.PathHelper;
import com.yakindu.sct.domain.c.runtime.resource.CachingPathResolver;
import com.yakindu.sct.domain.c.runtime.resource.LinkedFolderResolver;
import com.yakindu.sct.domain.c.runtime.resource.NameToIdConverter;
import com.yakindu.sct.domain.c.runtime.resource.transform.ICToModelTrafo;
import com.yakindu.sct.domain.c.runtime.resource.transform.PackageHierarchy;
import com.yakindu.sct.domain.c.runtime.resource.transform.c.CTypeNaming;
import com.yakindu.sct.domain.c.runtime.resource.transform.c.UnresolvableTypeProblem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CHeaderResource
extends ResourceImpl {
    protected Package rootPackage;
    @Accessors
    protected IASTTranslationUnit ast;
    @Inject
    protected ITypeSystem ts;
    @Extension
    protected static NameToIdConverter _nameToIdConverter = new NameToIdConverter();
    @Inject
    @Extension
    protected ICToModelTrafo trafo;
    @Inject
    @Extension
    protected CachingPathResolver _cachingPathResolver;
    @Inject
    @Extension
    private CTypeNaming _cTypeNaming;
    @Inject
    @Extension
    protected PathHelper _pathHelper;
    @Inject
    @Extension
    protected ITypeSystem _iTypeSystem;
    @Inject
    @Extension
    protected TypeBuilder _typeBuilder;
    protected Path location;
    @Extension
    protected TypesFactory factory = TypesFactory.eINSTANCE;

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            try {
                this.ast = this.createAST();
                this.rootPackage = this.createRootPackage();
                try {
                    if (this.ast != null) {
                        IIndex _index = this.ast.getIndex();
                        if (_index != null) {
                            _index.acquireReadLock();
                        }
                        this.trafo.transformToModel(this, options);
                    }
                }
                finally {
                    IIndex _index_1 = null;
                    if (this.ast != null) {
                        _index_1 = this.ast.getIndex();
                    }
                    if (_index_1 != null) {
                        _index_1.releaseReadLock();
                    }
                }
                this.getContents().add((Object)this.rootPackage);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IFile getIFile() {
        return EmfUriUtil.toFile((URI)this.getURI());
    }

    public Path getResourceLocation() {
        if (this.location == null) {
            IFile file = this.getIFile();
            this.location = file != null ? this._pathHelper.toPath((IResource)file, new LinkOption[0]) : this._pathHelper.toPath(this.getURI(), new LinkOption[0]);
        }
        return this.location;
    }

    public Path pathToDeclaringHeader(IASTNameOwner specifier) {
        boolean _tripleNotEquals_1;
        Path path;
        String name = this._cTypeNaming.name(specifier);
        if (name == null || name.toString().isEmpty()) {
            return this.getResourceLocation();
        }
        try {
            boolean _tripleNotEquals;
            IIndex _index = this.ast.getIndex();
            boolean bl = _tripleNotEquals = _index != null;
            if (_tripleNotEquals) {
                this.ast.getIndex().acquireReadLock();
            }
            path = this.pathToDeclaringHeader(this._cTypeNaming.getASTName(specifier).resolveBinding());
        }
        catch (Throwable throwable) {
            try {
                boolean _tripleNotEquals_12;
                IIndex _index_1 = this.ast.getIndex();
                boolean bl = _tripleNotEquals_12 = _index_1 != null;
                if (_tripleNotEquals_12) {
                    this.ast.getIndex().releaseReadLock();
                }
                throw throwable;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        IIndex _index_1 = this.ast.getIndex();
        boolean bl = _tripleNotEquals_1 = _index_1 != null;
        if (_tripleNotEquals_1) {
            this.ast.getIndex().releaseReadLock();
        }
        return path;
    }

    public Path pathToDeclaringHeader(IBinding binding) {
        if (binding != null && !(binding instanceof IProblemBinding)) {
            IName path;
            IName[] declNames;
            IName[] _converted_declNames = declNames = this.ast.getDefinitions(binding);
            IName _findFirst = null;
            if ((Iterable)Conversions.doWrapArray((Object)_converted_declNames) != null) {
                Functions.Function1 _function = it -> {
                    IASTFileLocation _fileLocation = it.getFileLocation();
                    return _fileLocation != null;
                };
                _findFirst = (IName)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_declNames)), (Functions.Function1)_function);
            }
            if ((path = _findFirst) != null) {
                return this._cachingPathResolver.resolve(path.getFileLocation().getFileName());
            }
        }
        return this.getResourceLocation();
    }

    public boolean addToPackage(Declaration member) {
        return this.addToPackage(this.rootPackage, member);
    }

    public boolean addToPackage(Declaration member, PackageHierarchy hierarchy) {
        boolean _xblockexpression = false;
        Package pkg = this.rootPackage;
        List<String> _segments = null;
        if (hierarchy != null) {
            _segments = hierarchy.getSegments();
        }
        for (String seg : _segments) {
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return Objects.equals(_name, seg);
            };
            Package next = (Package)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)pkg.getMember(), Package.class), (Functions.Function1)_function));
            if (next == null) {
                Package _doubleArrow;
                Package _createPackage = this.factory.createPackage();
                Procedures.Procedure1 _function_1 = it -> it.setName(seg);
                next = _doubleArrow = (Package)ObjectExtensions.operator_doubleArrow((Object)_createPackage, (Procedures.Procedure1)_function_1);
                EList _member = pkg.getMember();
                _member.add((Object)next);
            }
            pkg = next;
        }
        _xblockexpression = this.addToPackage(pkg, member);
        return _xblockexpression;
    }

    protected IASTTranslationUnit createAST() {
        IASTTranslationUnit _xblockexpression = null;
        IASTTranslationUnit ast = null;
        boolean _isPlatform = this.getURI().isPlatform();
        if (_isPlatform) {
            IFile res = EmfUriUtil.toFile((URI)this.getURI());
            if (res != null) {
                ICElement unit = CoreModel.getDefault().create(res.getFullPath());
                ast = this.createASTfromUnit(unit);
            }
        } else {
            boolean _isFile = this.getURI().isFile();
            if (_isFile) {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.getURI().query());
                if (_isNullOrEmpty) {
                    throw new IllegalStateException("Context workspace project required for file URIs!");
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getURI().query());
                ICProject cProject = CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(project.getName());
                ITranslationUnit unit_1 = CModelManager.getDefault().createTranslationUnitFrom(cProject, this.normalizeURI());
                ast = this.createASTfromUnit((ICElement)unit_1);
            }
        }
        _xblockexpression = ast;
        return _xblockexpression;
    }

    protected java.net.URI normalizeURI() {
        try {
            java.net.URI _xblockexpression = null;
            String _string = this.getURI().trimQuery().toString();
            java.net.URI uri = new java.net.URI(_string);
            _xblockexpression = uri.normalize();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IASTTranslationUnit createASTfromUnit(ICElement unit) {
        try {
            if (unit == null) return null;
            if (!(unit instanceof ITranslationUnit)) {
                return null;
            }
            ITranslationUnit tu = (ITranslationUnit)unit;
            IIndex index = CCorePlugin.getIndexManager().getIndex(tu.getCProject());
            try {
                index.acquireReadLock();
                IASTTranslationUnit iASTTranslationUnit = tu.getAST(index, this.getASTStyle(tu));
                return iASTTranslationUnit;
            }
            catch (Throwable _t) {
                if (!(_t instanceof CoreException)) throw Exceptions.sneakyThrow((Throwable)_t);
                CoreException e = (CoreException)_t;
                e.printStackTrace();
                return null;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected int getASTStyle(ITranslationUnit unit) {
        if (!this.isIndexerEnabled(unit) || this.isIndexerRunning()) {
            return 33;
        }
        return 39;
    }

    protected boolean isIndexerEnabled(ITranslationUnit unit) {
        return CCorePlugin.getIndexManager().isProjectIndexed(unit.getCProject());
    }

    protected boolean isIndexerRunning() {
        boolean _isIndexerIdle = CCorePlugin.getIndexManager().isIndexerIdle();
        return !_isIndexerIdle;
    }

    protected Package createRootPackage() {
        Package _xblockexpression = null;
        IFile res = this.getIFile();
        String _xifexpression = null;
        _xifexpression = res != null ? CHeaderResource.computePackageName(res) : this.computePackageName(this.getURI());
        String packageName = _xifexpression;
        Package _createPackage = this.factory.createPackage();
        Procedures.Procedure1 _function = it -> {
            it.setDomainID("com.yakindu.domain.c");
            it.setName(packageName);
            this._typeBuilder._no_namespace((AnnotatableElement)it);
        };
        _xblockexpression = (Package)ObjectExtensions.operator_doubleArrow((Object)_createPackage, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public String computePackageName(URI uri) {
        String _xblockexpression = null;
        String pathToHeader = uri.trimFileExtension().lastSegment();
        _xblockexpression = QualifiedName.create((String)_nameToIdConverter.convertToValidIdentifier(pathToHeader)).toString();
        return _xblockexpression;
    }

    public static String computePackageName(IFile headerFile) {
        String _xblockexpression = null;
        IResource resolvedFile = new LinkedFolderResolver().resolve((IResource)headerFile);
        IPath pathToHeader = resolvedFile.getProjectRelativePath().removeFileExtension();
        Functions.Function1 _function = it -> _nameToIdConverter.convertToValidIdentifier((String)it);
        _xblockexpression = QualifiedName.create((List)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)pathToHeader.segments())), (Functions.Function1)_function)).toString();
        return _xblockexpression;
    }

    protected boolean addToPackage(Package pkg, Declaration member) {
        boolean _xifexpression = false;
        if (member != null && !Objects.equals(member.getName(), "") && !Objects.equals(member, this.ts.getType("UnsupportedType"))) {
            boolean _xblockexpression = false;
            if (member instanceof TypeAlias) {
                this.removeIncompleteForwardDeclaredTypeAlias(pkg, (TypeAlias)member);
            }
            EList _member = pkg.getMember();
            _xifexpression = _xblockexpression = _member.add((Object)member);
        }
        return _xifexpression;
    }

    public void removeIncompleteForwardDeclaredTypeAlias(Package pkg, TypeAlias alias) {
        boolean _not;
        Functions.Function1 _function = it -> this._iTypeSystem.isAny(it.getType());
        Functions.Function1 _function_1 = it -> {
            String _name = it.getName();
            String _name_1 = alias.getName();
            return Objects.equals(_name, _name_1);
        };
        List existingTypeAlias = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)pkg.eAllContents(), TypeAlias.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)existingTypeAlias);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.removeUnresolvableTypeProblem(alias);
        }
        pkg.getMember().removeAll((Collection)existingTypeAlias);
    }

    public void removeUnresolvableTypeProblem(TypeAlias alias) {
        Functions.Function1 _function = it -> {
            String _message = it.getMessage();
            String _message_1 = UnresolvableTypeProblem.getMessage(alias.getType().getName());
            return Objects.equals(_message, _message_1);
        };
        Iterable resolvedErrors = IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.toList((Iterable)this.errors)), (Functions.Function1)_function);
        CollectionExtensions.removeAll((Collection)this.errors, (Iterable)resolvedErrors);
    }

    public EList<Declaration> getPackageMembers() {
        return this.rootPackage.getMember();
    }

    @Pure
    public IASTTranslationUnit getAst() {
        return this.ast;
    }

    public void setAst(IASTTranslationUnit ast) {
        this.ast = ast;
    }
}

