/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.resource;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.c.runtime.resource.IMacroDefinitionParser;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class DefaultMacroDefinitionParser
implements IMacroDefinitionParser {
    @Inject
    private IParser parser;
    @Inject
    private ITypeSystemInferrer typeInferrer;
    @Inject
    private IExpressionInterpreter interpreter;
    @Inject
    private ITypeSystem ts;
    private ParserRule parserRule = XtextFactory.eINSTANCE.createParserRule();

    public DefaultMacroDefinitionParser() {
        this.parserRule.setName(Expression.class.getSimpleName());
    }

    @Override
    public synchronized Pair<Type, Object> parseMacroDefinition(String expansion) {
        try {
            IParseResult parseResult = this.parser.parse(this.parserRule, (Reader)new StringReader(expansion));
            if (parseResult.hasSyntaxErrors()) {
                return Pair.of((Object)this.ts.getType("any"), null);
            }
            Expression macroExpr = (Expression)parseResult.getRootASTElement();
            Type type = this.typeInferrer.infer((EObject)macroExpr).getType();
            Object result = this.interpreter.evaluate(macroExpr, SRuntimeFactory.eINSTANCE.createExecutionContext());
            return Pair.of((Object)type, (Object)result);
        }
        catch (Exception e) {
            return Pair.of((Object)this.ts.getType("any"), null);
        }
    }
}

