/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.scoping;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.yakindu.base.types.TypesPackage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;

public class CDomainImportScope
extends ImportScope {
    private final List<ImportNormalizer> normalizers;
    private EClass type;

    public CDomainImportScope(List<ImportNormalizer> namespaceResolvers, IScope parent, ISelectable importFrom, EClass type, boolean ignoreCase) {
        super(namespaceResolvers, parent, importFrom, type, ignoreCase);
        this.normalizers = this.removeDuplicates(namespaceResolvers);
        this.type = type;
    }

    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        ArrayList result = Lists.newArrayList();
        QualifiedName resolvedQualifiedName = null;
        ISelectable importFrom = this.getImportFrom();
        for (ImportNormalizer normalizer : this.normalizers) {
            QualifiedName resolvedName = normalizer.resolve(name);
            if (resolvedName == null) continue;
            Iterable resolvedElements = importFrom.getExportedObjects(this.type, resolvedName, this.isIgnoreCase());
            for (IEObjectDescription resolvedElement : resolvedElements) {
                IEObjectDescription existing;
                if (resolvedQualifiedName == null) {
                    resolvedQualifiedName = resolvedName;
                } else if (!(resolvedQualifiedName.equals((Object)resolvedName) || (existing = (IEObjectDescription)result.get(0)).getEObjectOrProxy() == resolvedElement.getEObjectOrProxy() || this.isNamespace(existing) && this.isNamespace(resolvedElement))) {
                    return Collections.emptyList();
                }
                QualifiedName alias = normalizer.deresolve(resolvedElement.getName());
                if (alias == null) {
                    throw new IllegalStateException("Couldn't deresolve " + String.valueOf(resolvedElement.getName()) + " with import " + String.valueOf(normalizer));
                }
                AliasedEObjectDescription aliasedEObjectDescription = new AliasedEObjectDescription(alias, resolvedElement);
                result.add(aliasedEObjectDescription);
            }
        }
        return result;
    }

    protected Iterable<IEObjectDescription> getAliasedElements(Iterable<IEObjectDescription> candidates) {
        LinkedHashMultimap keyToDescription = LinkedHashMultimap.create();
        HashMultimap keyToNormalizer = HashMultimap.create();
        for (IEObjectDescription imported : candidates) {
            QualifiedName fullyQualifiedName = imported.getName();
            for (ImportNormalizer normalizer : this.normalizers) {
                QualifiedName alias = normalizer.deresolve(fullyQualifiedName);
                if (alias == null) continue;
                QualifiedName key = alias;
                if (this.isIgnoreCase()) {
                    key = key.toLowerCase();
                }
                keyToDescription.put((Object)key, (Object)new AliasedEObjectDescription(alias, imported));
                keyToNormalizer.put((Object)key, (Object)normalizer);
            }
        }
        for (QualifiedName name : keyToNormalizer.keySet()) {
            if (keyToNormalizer.get((Object)name).size() <= 1) continue;
            ArrayList elements = new ArrayList(keyToDescription.get((Object)name));
            for (IEObjectDescription elem : elements) {
                if (this.isNamespace(elem)) continue;
                keyToDescription.remove((Object)name, (Object)elem);
            }
        }
        return keyToDescription.values();
    }

    protected boolean isNamespace(IEObjectDescription element) {
        return element.getEClass().equals(TypesPackage.Literals.PACKAGE);
    }
}

