/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.decoratorprovider;

import com.yakindu.base.gmf.runtime.decorators.AbstractDecoratorProvider;
import com.yakindu.base.gmf.runtime.decorators.InteractiveDecorator;
import com.yakindu.base.xtext.utils.jface.viewers.util.ActiveEditorTracker;
import com.yakindu.sct.model.sgraph.SpecificationElement;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.editparts.StatechartTextEditPart;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sct.ui.editor.utils.GMFNotationUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public class DefinitionSectionDecorationProvider
extends AbstractDecoratorProvider
implements IDecoratorProvider {
    protected static final String DECORATOR_KEY = DefinitionSectionDecorator.class.getSimpleName();

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        Object adapter = decoratorTarget.getAdapter(EObject.class);
        if (adapter instanceof SpecificationElement) {
            decoratorTarget.installDecorator((Object)DECORATOR_KEY, (IDecorator)new DefinitionSectionDecorator(decoratorTarget));
        }
    }

    public static class DefinitionSectionDecorator
    extends InteractiveDecorator {
        private static final LineBorder decorationLineBorder = new LineBorder(ColorConstants.lightGray);
        private static final MarginBorder marginBorder = new MarginBorder(1, 0, 1, 0);
        private static final Insets decorationExpandInsets = new Insets(0, 0, 0, 3);
        private static final String TOOLTIP_TEXT = "Pin statechart definition section";
        private static Cursor handCursor;
        private static final int SHIFT_DY = 1;
        private static final int SHIFT_DX = -2;
        private DecorationMouseMotionListener decorationMouseMotionListener;

        public DefinitionSectionDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
        }

        protected void disposeDecoration() {
            if (handCursor != null) {
                handCursor.dispose();
            }
            if (this.getDecoration() != null && this.decorationMouseMotionListener != null) {
                this.getDecoration().removeMouseMotionListener((MouseMotionListener)this.decorationMouseMotionListener);
                this.decorationMouseMotionListener = null;
            }
            super.disposeDecoration();
        }

        protected IDecoratorTarget.Direction getDecoratorPosition() {
            return IDecoratorTarget.Direction.NORTH_WEST;
        }

        protected Image getDecorationImage(EObject element) {
            return StatechartImages.PIN.image();
        }

        protected boolean shouldDecorate(EObject element) {
            if (this.getDecoratorTarget().getAdapter(IPrimaryEditPart.class) instanceof StatechartTextEditPart) {
                StatechartTextEditPart adapter = (StatechartTextEditPart)((Object)this.getDecoratorTarget().getAdapter(IPrimaryEditPart.class));
                BooleanValueStyle style = GMFNotationUtil.getBooleanValueStyle(adapter.getNotationView(), "inlineDefinitionSection");
                return style == null ? true : style.isBooleanValue();
            }
            return false;
        }

        protected Decoration createDecoration(EObject semanticElement) {
            Decoration decoration = super.createDecoration(semanticElement);
            if (decoration != null && semanticElement != null) {
                this.installIconHighlighting(decoration, semanticElement);
            }
            return decoration;
        }

        protected void installIconHighlighting(Decoration decoration, EObject semanticElement) {
            decoration.getBounds().translate(-2, 1);
            decoration.getBounds().expand(decorationExpandInsets);
            if (this.decorationMouseMotionListener == null) {
                this.decorationMouseMotionListener = new DecorationMouseMotionListener(decoration);
            }
            decoration.addMouseMotionListener((MouseMotionListener)this.decorationMouseMotionListener);
        }

        protected void mousePressed(Decoration decoration, EObject element) {
            if (this.getDecoratorTarget().getAdapter(IPrimaryEditPart.class) instanceof StatechartTextEditPart) {
                SetCommand command;
                StatechartTextEditPart editPart = (StatechartTextEditPart)((Object)this.getDecoratorTarget().getAdapter(IPrimaryEditPart.class));
                Diagram diagramReference = this.getDiagramReference((EditPart)editPart);
                BooleanValueStyle inlineStyle = GMFNotationUtil.getBooleanValueStyle((View)diagramReference, "inlineDefinitionSection");
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagramReference);
                if (inlineStyle == null) {
                    inlineStyle = DiagramPartitioningUtil.createInlineDefinitionSectionStyle();
                    inlineStyle.setBooleanValue(true);
                    command = this.addBooleanValueStyle((EditPart)editPart, inlineStyle, domain);
                    domain.getCommandStack().execute((Command)command);
                }
                command = this.setBooleanValueStyle(inlineStyle, domain);
                domain.getCommandStack().execute((Command)command);
                editPart.refresh();
                this.updateActiveEditor();
            }
        }

        protected Diagram getDiagramReference(EditPart editPart) {
            return ((View)editPart.getRoot().getContents().getModel()).getDiagram();
        }

        protected void updateActiveEditor() {
            IEditorPart lastActiveEditor = ActiveEditorTracker.getLastActiveEditor();
            if (lastActiveEditor instanceof StatechartDiagramEditor) {
                ((StatechartDiagramEditor)lastActiveEditor).toggleDefinitionSection();
            }
        }

        protected SetCommand setBooleanValueStyle(BooleanValueStyle inlineStyle, TransactionalEditingDomain domain) {
            SetCommand command = new SetCommand((EditingDomain)domain, (EObject)inlineStyle, (EStructuralFeature)NotationPackage.Literals.BOOLEAN_VALUE_STYLE__BOOLEAN_VALUE, (Object)(!inlineStyle.isBooleanValue() ? 1 : 0));
            return command;
        }

        protected AddCommand addBooleanValueStyle(EditPart editPart, BooleanValueStyle inlineStyle, TransactionalEditingDomain domain) {
            AddCommand command = new AddCommand((EditingDomain)domain, (EObject)this.getDiagramReference(editPart), (EStructuralFeature)NotationPackage.Literals.VIEW__STYLES, (Object)inlineStyle);
            return command;
        }

        protected IFigure getToolTipFigure(EObject element) {
            return new Label(TOOLTIP_TEXT);
        }

        protected class DecorationMouseMotionListener
        implements MouseMotionListener {
            private final Decoration decoration;

            protected DecorationMouseMotionListener(Decoration decoration) {
                this.decoration = decoration;
            }

            public void mouseEntered(MouseEvent me) {
                if (handCursor == null || handCursor.isDisposed()) {
                    handCursor = new Cursor((Device)Display.getDefault(), 21);
                }
                this.decoration.setCursor(handCursor);
                this.decoration.setBorder((Border)decorationLineBorder);
            }

            public void mouseExited(MouseEvent me) {
                this.decoration.setBorder((Border)marginBorder);
            }

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        }
    }
}

