/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.editor;

import com.yakindu.sct.domain.extension.DomainStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class DomainStatusLabel
extends Composite {
    private static final Font DOMAIN_STATUS_FONT = new Font(null, new FontData("Verdana", 10, 1));
    private CLabel label;
    private Link link;

    public DomainStatusLabel(DomainStatus status, Composite parent) {
        super(parent, 2048);
        RowLayout layout = new RowLayout(256);
        this.setLayout((Layout)layout);
        this.setBackground(ColorConstants.white);
        this.createLabel(status);
        this.createLink(status);
    }

    protected void createLink(final DomainStatus status) {
        this.link = new Link((Composite)this, 0);
        this.link.setFont(DOMAIN_STATUS_FONT);
        this.link.setBackground(ColorConstants.white);
        this.link.setText(this.getMessage(status));
        this.link.setForeground(this.getSeverityColor(status.getSeverity()));
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                status.handleLink();
            }
        });
    }

    protected void createLabel(DomainStatus status) {
        this.label = new CLabel((Composite)this, 0);
        this.label.setFont(DOMAIN_STATUS_FONT);
        this.label.setBackground(ColorConstants.white);
        this.label.setForeground(this.getSeverityColor(status.getSeverity()));
        this.label.setImage(this.getSeverityImage(status.getSeverity()));
    }

    protected String getMessage(DomainStatus domainStatus) {
        if (domainStatus.getSeverity() == DomainStatus.Severity.ERROR) {
            return domainStatus.getMessage() + " - editor is in readonly mode.";
        }
        return domainStatus.getMessage();
    }

    protected Color getSeverityColor(DomainStatus.Severity severity) {
        if (severity == DomainStatus.Severity.ERROR) {
            return ColorConstants.red;
        }
        if (severity == DomainStatus.Severity.WARNING) {
            return ColorConstants.darkBlue;
        }
        return ColorConstants.darkBlue;
    }

    protected Image getSeverityImage(DomainStatus.Severity severity) {
        if (severity == DomainStatus.Severity.ERROR) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (severity == DomainStatus.Severity.WARNING) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    }
}

