/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.partitioning;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class ResourceUnloadingTool {
    public static void unloadEditorInput(ResourceSet resourceSet, IEditorInput editorInput) {
        IEditorReference[] editorReferences;
        final EList resources = resourceSet.getResources();
        final ArrayList resourcesToUnload = new ArrayList(resources);
        try {
            editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        }
        catch (NullPointerException exc) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference openEditorReference = iEditorReferenceArray[n2];
            try {
                Resource diagramResource;
                IEditingDomainProvider openDiagramEditor;
                ResourceSet diagramResourceSet;
                IEditorPart openEditor;
                IEditorInput openEditorInput = openEditorReference.getEditorInput();
                if (openEditorInput != editorInput && (openEditor = openEditorReference.getEditor(false)) instanceof IEditingDomainProvider && (diagramResourceSet = (openDiagramEditor = (IEditingDomainProvider)openEditor).getEditingDomain().getResourceSet()) == resourceSet && (diagramResource = ResourceUnloadingTool.getDiagramResource(diagramResourceSet, openEditorInput)) != null) {
                    resourcesToUnload.remove(diagramResource);
                    Collection imports = EMFCoreUtil.getImports((Resource)diagramResource);
                    resourcesToUnload.removeAll(imports);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++n2;
        }
        try {
            TransactionUtil.getEditingDomain((ResourceSet)resourceSet).runExclusive(new Runnable(){

                @Override
                public void run() {
                    for (Resource resourceToUnload : resourcesToUnload) {
                        try {
                            resourceToUnload.unload();
                            resources.remove((Object)resourceToUnload);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static Resource getDiagramResource(ResourceSet resourceSet, IEditorInput editorInput) {
        Resource diagramResource = null;
        if (editorInput instanceof URIEditorInput) {
            URI resourceURI = ((URIEditorInput)editorInput).getURI().trimFragment();
            diagramResource = resourceSet.getResource(resourceURI, false);
        } else if (editorInput instanceof IDiagramEditorInput) {
            Diagram diagram = ((IDiagramEditorInput)editorInput).getDiagram();
            diagramResource = diagram.eResource();
        } else if (editorInput instanceof IFileEditorInput) {
            URI resourceURI = URI.createPlatformResourceURI((String)((IFileEditorInput)editorInput).getFile().getFullPath().toString(), (boolean)true);
            diagramResource = resourceSet.getResource(resourceURI, false);
        }
        return diagramResource;
    }
}

