/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.providers;

import com.yakindu.base.gmf.runtime.palette.DirectEditCreationTool;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.providers.ISCTPaletteFactory;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.tools.ConnectionCreationTool;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class DefaultSCTPaletteFactory
implements ISCTPaletteFactory {
    public static final String PLUGIN_ID_PREFIX = "com.yakindu.sct.ui.editor.";
    public static final String STATECHART_ID = "Statechart";
    public static final String REGION_ID = "Region";
    public static final String STATE_ID = "State";
    public static final String COMPOSITE_STATE_ID = "CompositeState";
    public static final String ORTHOGONAL_STATE_ID = "OrthogonalState";
    public static final String TRANSITION_ID = "Transition";
    public static final String CHOICE_ID = "Choice";
    public static final String ENTRY_ID = "Entry";
    public static final String DEEPHISTORY_ID = "DeepHistory";
    public static final String SHALLOWHISTORY_ID = "ShallowHistory";
    public static final String EXITNODE_ID = "Exit";
    public static final String FINALSTATE_ID = "FinalState";
    public static final String SYNCHRONIZATION_ID = "Synchronization";

    @Override
    public void createPaletteEntries(PaletteRoot root) {
        PaletteContainer container = this.createToolsCategory(root);
        this.createTransitionEntry(container);
        this.createStateEntry(container);
        this.createCompositeStateEntry(container);
        this.createOrthogonalStateEntry(container);
        this.createRegionEntry(container);
        this.createInitialStateEntry(container);
        this.createShallowHistoryEntry(container);
        this.createDeepHistoryEntry(container);
        this.createFinalStateEntry(container);
        this.createExitEntry(container);
        this.createChoiceEntry(container);
        this.createSynchronizationEntry(container);
    }

    protected PaletteContainer createToolsCategory(PaletteRoot root) {
        PaletteDrawer drawer = new PaletteDrawer("Tools");
        root.add((PaletteEntry)drawer);
        return drawer;
    }

    protected void createTransitionEntry(PaletteContainer container) {
        container.add((PaletteEntry)new ConnectionCreationToolEntry(TRANSITION_ID, "Creates a transition", this.getType(TRANSITION_ID), this.findIcon("icons/obj16/transition-16.png"), this.findIcon("icons/obj32/transition-32.png")));
    }

    protected void createStateEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry(STATE_ID, "Creates a state", this.getType(STATE_ID), this.findIcon("icons/obj16/State-16.png"), this.findIcon("icons/obj32/State-32.png"), true));
    }

    protected void createCompositeStateEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry("Composite State", "Creates a composite state", this.getType(COMPOSITE_STATE_ID), this.findIcon("icons/obj16/Composite-State-16.png"), this.findIcon("icons/obj32/Composite-State-32.png"), true));
    }

    protected void createOrthogonalStateEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry("Orthogonal State", "Creates an orthogonal state", this.getType(ORTHOGONAL_STATE_ID), this.findIcon("icons/obj16/Orthogonal-State-16.png"), this.findIcon("icons/obj32/Orthogonal-State-32.png"), true));
    }

    protected void createRegionEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry(REGION_ID, "Creates a region", this.getType(REGION_ID), this.findIcon("icons/obj16/Region-16.png"), this.findIcon("icons/obj32/Region-32.png"), false));
    }

    protected void createInitialStateEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry(ENTRY_ID, "Creates an initial state", this.getType(ENTRY_ID), this.findIcon("icons/obj16/Initial-State-16.png"), this.findIcon("icons/obj32/Initial-State-32.png"), false));
    }

    protected void createShallowHistoryEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry("Shallow History", "Creates a shallow state", this.getType(SHALLOWHISTORY_ID), this.findIcon("icons/obj16/Shallow-History-16.png"), this.findIcon("icons/obj32/Shallow-History-32.png"), false));
    }

    protected void createDeepHistoryEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry("Deep History", "Creates a deep history", this.getType(DEEPHISTORY_ID), this.findIcon("icons/obj16/Deep-History-16.png"), this.findIcon("icons/obj32/Deep-History-32.png"), false));
    }

    protected void createFinalStateEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry("Final State", "Creates a final state", this.getType(FINALSTATE_ID), this.findIcon("icons/obj16/Final-State-16.png"), this.findIcon("icons/obj32/Final-State-32.png"), false));
    }

    protected void createExitEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry("Exit Node", "Creates an exit node", this.getType(EXITNODE_ID), this.findIcon("icons/obj16/Exit-Point-16.png"), this.findIcon("icons/obj32/Exit-Point-32.png"), false));
    }

    protected void createChoiceEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry(CHOICE_ID, "Creates a choice", this.getType(CHOICE_ID), this.findIcon("icons/obj16/Choice-16.png"), this.findIcon("icons/obj32/Choice-32.png"), false));
    }

    protected void createSynchronizationEntry(PaletteContainer container) {
        container.add((PaletteEntry)new CreationToolEntry(SYNCHRONIZATION_ID, "Creates a synchronization", this.getType(SYNCHRONIZATION_ID), this.findIcon("icons/obj16/Synchronization-16.png"), this.findIcon("icons/obj32/Synchronization-32.png"), false));
    }

    protected IElementType getType(String id) {
        return ElementTypeRegistry.getInstance().getType(PLUGIN_ID_PREFIX + id);
    }

    protected ImageDescriptor findIcon(String iconPath) {
        return this.getImageDescriptor(iconPath, DiagramActivator.getDefault().getBundle());
    }

    protected ImageDescriptor getImageDescriptor(String iconPath, Bundle bundle) {
        try {
            if (iconPath != null) {
                URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(iconPath), null);
                URL uRL = fullPathString = fullPathString != null ? fullPathString : new URL(iconPath);
                if (fullPathString != null) {
                    return ImageDescriptor.createFromURL((URL)fullPathString);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class ConnectionCreationToolEntry
    extends CombinedTemplateCreationEntry {
        private IElementType elementType;
        private Tool tool;

        public ConnectionCreationToolEntry(String label, String shortDesc, IElementType elementType, ImageDescriptor iconSmall, ImageDescriptor iconLarge) {
            super(label, shortDesc, null, iconSmall, iconLarge);
            this.elementType = elementType;
        }

        public Tool createTool() {
            if (this.tool == null) {
                this.tool = new ConnectionCreationTool(this.elementType);
            }
            return this.tool;
        }
    }

    public static class CreationToolEntry
    extends CombinedTemplateCreationEntry {
        private IElementType elementType;
        private boolean directEdit;
        private Tool tool;

        public CreationToolEntry(String label, String shortDesc, IElementType elementType, ImageDescriptor iconSmall, ImageDescriptor iconLarge, boolean directEdit) {
            super(label, shortDesc, null, iconSmall, iconLarge);
            this.elementType = elementType;
            this.directEdit = directEdit;
            this.setTemplate(new PaletteToolEntry(null, null, null){

                public Tool createTool() {
                    return this.createTool();
                }
            });
        }

        public Tool createTool() {
            if (this.tool == null) {
                this.tool = new DirectEditCreationTool(this.elementType, this.directEdit);
            }
            return this.tool;
        }
    }
}

