/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.providers;

import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.ui.editor.editor.figures.PriorityFigure;
import com.yakindu.sct.ui.editor.editparts.RegionEditPart;
import com.yakindu.sct.ui.editor.providers.AbstractPriorityDecorationProvider;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class RegionPriorityDecorationProvider
extends AbstractPriorityDecorationProvider {
    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (this.shouldInstall(((DiagramEditDomain)ed).getEditorPart()) && editPart instanceof RegionEditPart) {
                IDecorator decorator = this.createStatusDecorator(decoratorTarget);
                this.decorators.add(decorator);
                decoratorTarget.installDecorator(this.getDecoratorKey(), decorator);
            }
        }
    }

    protected IDecorator createStatusDecorator(IDecoratorTarget decoratorTarget) {
        return new RegionPriorityDecorator(decoratorTarget);
    }

    public static class RegionPriorityDecorator
    extends AbstractPriorityDecorationProvider.AbstractPriorityDecorator {
        public RegionPriorityDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget, SGraphPackage.Literals.COMPOSITE_ELEMENT__REGIONS);
        }

        @Override
        public void activate() {
            if (!(this.semanticElement instanceof Region)) {
                return;
            }
            if (this.semanticElement.eContainer() != null) {
                this.owningElement = this.semanticElement.eContainer();
            }
            super.activate();
        }

        @Override
        public void deactivate() {
            if (!(this.semanticElement instanceof Region)) {
                return;
            }
            this.owningElement = null;
            super.deactivate();
        }

        @Override
        public boolean needsDecoration(IGraphicalEditPart editPart) {
            Region element = (Region)editPart.resolveSemanticElement();
            CompositeElement container = (CompositeElement)element.eContainer();
            return container.getRegions().size() > 1;
        }

        @Override
        public void createDecorators(IGraphicalEditPart editPart) {
            PriorityFigure figure = new PriorityFigure(MapModeUtil.getMapMode(), this.getPriority(editPart));
            figure.setSize(10, 10);
            this.setDecoration(this.getDecoratorTarget().addShapeDecoration((IFigure)figure, IDecoratorTarget.Direction.NORTH_WEST, -1, false));
        }

        @Override
        public int getPriority(IGraphicalEditPart editPart) {
            Region element = (Region)editPart.resolveSemanticElement();
            CompositeElement container = (CompositeElement)element.eContainer();
            int indexOf = container.getRegions().indexOf((Object)element);
            return indexOf + 1;
        }
    }
}

