/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.providers;

import com.yakindu.base.gmf.runtime.decorators.AbstractDecoratorProvider;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.Pseudostate;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.ui.validation.SCTIssue;
import com.yakindu.sct.ui.editor.editparts.BorderItemEditPart;
import com.yakindu.sct.ui.editor.utils.GMFNotationUtil;
import com.yakindu.sct.ui.editor.validation.IValidationIssueStore;
import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public class StatechartValidationDecorationProvider
extends AbstractDecoratorProvider
implements IDecoratorProvider {
    private static final String KEY = "com.yakindu.sct.ui.editor.validation";
    private IValidationIssueStore issueStore;

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof BorderItemEditPart) {
            return;
        }
        if (editPart instanceof IPrimaryEditPart && (editPart instanceof GraphicalEditPart || editPart instanceof AbstractConnectionEditPart)) {
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (this.shouldInstall(((DiagramEditDomain)ed).getEditorPart())) {
                decoratorTarget.installDecorator((Object)this.getDecoratorKey(), (IDecorator)this.createStatusDecorator(decoratorTarget, this.issueStore));
            }
        }
    }

    protected boolean shouldInstall(IEditorPart part) {
        if (part instanceof StatechartDiagramEditor) {
            this.issueStore = (IValidationIssueStore)part.getAdapter(IValidationIssueStore.class);
            return true;
        }
        if (part == null) {
            this.issueStore = new IValidationIssueStore.NullImpl();
            return true;
        }
        return false;
    }

    protected String getDecoratorKey() {
        return KEY;
    }

    protected ValidationDecorator createStatusDecorator(IDecoratorTarget decoratorTarget, IValidationIssueStore store) {
        return new ValidationDecorator(decoratorTarget, store);
    }

    public static class ValidationDecorator
    extends AbstractDecorator
    implements IValidationIssueStore.IValidationIssueStoreListener {
        private static final String SUB_DIAGRAM_ERRORS = "The subdiagram contains errors.";
        private IValidationIssueStore store;
        private String semanticID;

        public ValidationDecorator(IDecoratorTarget decoratorTarget, IValidationIssueStore store) {
            super(decoratorTarget);
            this.store = store;
        }

        public void refresh() {
            Optional<EObject> element = this.getTargetEObject();
            if (!element.isPresent()) {
                return;
            }
            this.semanticID = element.get().eResource().getURIFragment(element.get());
            this.removeDecoration();
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getViewer() == null || !(editPart instanceof IPrimaryEditPart)) {
                return;
            }
            this.decorate(this.getTargetView().get());
        }

        protected Optional<EObject> getTargetEObject() {
            EObject element;
            Optional<View> view = this.getTargetView();
            if (view.isPresent() && (element = view.get().getElement()) != null) {
                return Optional.of(element);
            }
            return Optional.empty();
        }

        private Optional<View> getTargetView() {
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return Optional.empty();
            }
            return Optional.of(view);
        }

        public void activate() {
            this.store.addIssueStoreListener(this);
        }

        public void deactivate() {
            this.store.removeIssueStoreListener(this);
            super.deactivate();
        }

        protected void decorate(View view) {
            List<SCTIssue> issues = this.store.getIssues(this.semanticID);
            SCTIssue subDiagramIssue = this.getSubDiagramIssue(view);
            if (subDiagramIssue != null) {
                issues.add(subDiagramIssue);
            }
            Severity severity = Severity.INFO;
            Label toolTip = null;
            if (issues.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < issues.size()) {
                Issue issue = (Issue)issues.get(i);
                Severity nextSeverity = issue.getSeverity();
                Image nextImage = this.getImage(nextSeverity);
                if (toolTip == null) {
                    toolTip = new Label(issue.getMessage(), nextImage);
                } else {
                    if (toolTip.getChildren().isEmpty()) {
                        Label comositeLabel = new Label();
                        FlowLayout fl = new FlowLayout(false);
                        fl.setMinorSpacing(0);
                        comositeLabel.setLayoutManager((LayoutManager)fl);
                        comositeLabel.add((IFigure)toolTip);
                        toolTip = comositeLabel;
                    }
                    toolTip.add((IFigure)new Label(issue.getMessage(), nextImage));
                }
                severity = nextSeverity.ordinal() < severity.ordinal() ? nextSeverity : severity;
                ++i;
            }
            if (view instanceof Edge) {
                this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(this.getImage(severity), 50, true));
                this.getDecoration().setToolTip(toolTip);
            } else {
                int margin = view.getElement() instanceof Pseudostate || view.getElement() instanceof FinalState ? 0 : -1;
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.getImage(severity), IDecoratorTarget.Direction.NORTH_EAST, margin, false));
                this.getDecoration().setToolTip((IFigure)toolTip);
            }
        }

        protected SCTIssue getSubDiagramIssue(View view) {
            BooleanValueStyle style;
            if ("State".equals(view.getType()) && (style = GMFNotationUtil.getBooleanValueStyle(view, "isInline")) != null && !style.isBooleanValue()) {
                EObject element = view.getElement();
                TreeIterator eAllContents = element.eAllContents();
                while (eAllContents.hasNext()) {
                    EObject next = (EObject)eAllContents.next();
                    if (next instanceof Transition && next.eContainer() == element) {
                        eAllContents.prune();
                        continue;
                    }
                    String semanticURI = EcoreUtil.getURI((EObject)next).fragment();
                    List<SCTIssue> issues = this.store.getIssues(semanticURI);
                    for (SCTIssue issue : issues) {
                        if (!Severity.ERROR.equals((Object)issue.getSeverity())) continue;
                        Issue.IssueImpl result = new Issue.IssueImpl();
                        result.setMessage(SUB_DIAGRAM_ERRORS);
                        result.setSeverity(Severity.ERROR);
                        return new SCTIssue((Issue)result, issue.getSemanticURI());
                    }
                }
            }
            return null;
        }

        protected Image getImage(Severity severity) {
            String imageName = "IMG_OBJS_ERROR_TSK";
            switch (severity) {
                case ERROR: {
                    imageName = "IMG_OBJS_ERROR_TSK";
                    break;
                }
                case WARNING: {
                    imageName = "IMG_OBJS_WARN_TSK";
                    break;
                }
                default: {
                    imageName = "IMG_OBJS_INFO_TSK";
                }
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
        }

        @Override
        public void issuesChanged() {
            this.refresh();
        }

        @Override
        public String getSemanticURI() {
            return this.semanticID;
        }

        @Override
        public boolean notifyOnChildChange() {
            Optional<View> view = this.getTargetView();
            if (view.isPresent() && "State".equals(view.get().getType())) {
                BooleanValueStyle style = GMFNotationUtil.getBooleanValueStyle(view.get(), "isInline");
                return style == null ? false : !style.isBooleanValue();
            }
            return false;
        }
    }
}

