/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.yakindu.sct.model.sgraph.ui.validation.ISctIssueCreator;
import com.yakindu.sct.model.sgraph.ui.validation.SCTIssue;
import com.yakindu.sct.ui.editor.validation.IResourceChangeToIssueProcessor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class DefaultResourceChangeToIssueProcessor
implements IResourceChangeToIssueProcessor {
    @Inject
    private ISctIssueCreator issueCreator;
    private Multimap<String, SCTIssue> currentIssues;
    private Set<String> changedIssuesElementIDs;

    @Override
    public IResourceChangeToIssueProcessor.ResourceDeltaToIssueResult process(IResourceChangeEvent event, Resource connectedResource, Multimap<String, SCTIssue> visibleIssues) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)connectedResource);
        if (file == null) {
            return null;
        }
        IResourceDelta deltaForFile = this.getDeltaForFile(event, file);
        if (deltaForFile == null) {
            return null;
        }
        this.currentIssues = HashMultimap.create(visibleIssues);
        this.changedIssuesElementIDs = Sets.newHashSet();
        if (4 == deltaForFile.getKind() && (deltaForFile.getFlags() & 0x20000) != 0) {
            this.processMarkerDelta(deltaForFile);
        }
        return new IResourceChangeToIssueProcessor.ResourceDeltaToIssueResult(this.currentIssues, this.changedIssuesElementIDs);
    }

    protected IResourceDelta getDeltaForFile(IResourceChangeEvent event, IFile file) {
        String[] segments = file.getFullPath().segments();
        IResourceDelta currentDelta = event.getDelta();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            IResourceDelta matchingDelta = currentDelta.findMember((IPath)new Path(segment));
            if (matchingDelta == null) {
                return null;
            }
            currentDelta = matchingDelta;
            ++n2;
        }
        return currentDelta;
    }

    protected void processMarkerDelta(IResourceDelta delta) {
        IMarkerDelta[] markerDeltas;
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas = this.getSortedMarkerDelta(delta);
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            Object elementID = markerDelta.getAttribute("elementId");
            if (elementID != null) {
                this.dispatchMarkerDelta(markerDelta, elementID.toString());
            }
            ++n2;
        }
    }

    private IMarkerDelta[] getSortedMarkerDelta(IResourceDelta delta) {
        IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
        Arrays.sort(markerDeltas, new Comparator<IMarkerDelta>(){

            @Override
            public int compare(IMarkerDelta o1, IMarkerDelta o2) {
                return -Integer.valueOf(o1.getKind()).compareTo(o2.getKind());
            }
        });
        return markerDeltas;
    }

    protected void dispatchMarkerDelta(IMarkerDelta iMarkerDelta, String elementID) {
        switch (iMarkerDelta.getKind()) {
            case 1: {
                this.addSCTIssue(iMarkerDelta, elementID);
                break;
            }
            case 2: {
                this.removeSCTIssue(iMarkerDelta, elementID);
                break;
            }
            case 4: {
                this.removeSCTIssue(iMarkerDelta, elementID);
                this.addSCTIssue(iMarkerDelta, elementID);
                break;
            }
        }
    }

    protected void addSCTIssue(IMarkerDelta iMarkerDelta, String elementID) {
        this.currentIssues.put((Object)elementID, (Object)this.issueCreator.createFromMarker(iMarkerDelta.getMarker(), elementID));
        this.changedIssuesElementIDs.add(elementID);
    }

    protected void removeSCTIssue(IMarkerDelta iMarkerDelta, String elementID) {
        String message = (String)iMarkerDelta.getAttributes().get("message");
        Iterator iterator = this.currentIssues.get((Object)elementID).iterator();
        while (iterator.hasNext()) {
            SCTIssue sctIssue = (SCTIssue)iterator.next();
            if (!sctIssue.getMessage().equals(message)) continue;
            iterator.remove();
        }
        this.changedIssuesElementIDs.add(elementID);
    }
}

