/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.wizards;

import com.yakindu.base.base.BasePackage;
import com.yakindu.base.gmf.runtime.util.EditPartUtils;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.wizards.DiagramCreator;
import com.yakindu.sct.ui.editor.wizards.DomainWizardPage;
import com.yakindu.sct.ui.editor.wizards.PerspectiveUtil;
import com.yakindu.sct.ui.wizards.ModelCreationWizardPage;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.EcoreUtil2;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public class CreationWizard
extends Wizard
implements INewWizard {
    public static final String ID = "com.yakindu.sct.ui.editor.StatechartDiagramWizard";
    protected IStructuredSelection selection = new StructuredSelection();
    protected ModelCreationWizardPage modelCreationPage;
    protected DomainWizardPage domainWizardPage;
    protected Resource diagram;
    private boolean openOnCreate = true;
    protected PreferencesHint preferencesHint = DiagramActivator.DIAGRAM_PREFERENCES_HINT;
    private IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("New itemis CREATE Statechart");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.initModelCreationPage();
        this.initDomainWizardPage();
    }

    protected void initModelCreationPage() {
        this.modelCreationPage = new ModelCreationWizardPage("DiagramModelFile", this.getSelection(), "ysc");
        this.modelCreationPage.setTitle("itemis CREATE SCT Diagram");
        this.modelCreationPage.setDescription("Create a new itemis CREATE SCT diagram file.");
        this.modelCreationPage.setImageDescriptor(StatechartImages.LOGO.imageDescriptor());
        this.addPage((IWizardPage)this.modelCreationPage);
    }

    protected void initDomainWizardPage() {
        if (DomainRegistry.getDomains().size() > 1) {
            this.domainWizardPage = new DomainWizardPage("DomainWizard");
            this.domainWizardPage.setTitle("Select Statechart Domain");
            this.domainWizardPage.setDescription("Select the domain you want to create a statechart for.");
            this.domainWizardPage.setImageDescriptor(StatechartImages.LOGO.imageDescriptor());
            this.addPage((IWizardPage)this.domainWizardPage);
        }
    }

    public boolean performFinish() {
        final DiagramCreationDesccription create = this.getDiagramDescription();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                CreationWizard.this.diagram = new DiagramCreator().createDiagram(create, monitor);
                if (CreationWizard.this.isOpenOnCreate() && CreationWizard.this.diagram != null) {
                    try {
                        CreationWizard.this.openDiagram(CreationWizard.this.diagram);
                        PerspectiveUtil.switchToModelingPerspective(CreationWizard.this.workbench.getActiveWorkbenchWindow());
                    }
                    catch (PartInitException e) {
                        DiagramActivator.getDefault().getLog().log((IStatus)new Status(2, "com.yakindu.sct.ui.editor", "Editor can't be opened", (Throwable)e));
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            return false;
        }
        return this.diagram != null;
    }

    protected DiagramCreationDesccription getDiagramDescription() {
        URI uri = this.modelCreationPage.getURI();
        String domainID = this.domainWizardPage != null ? this.domainWizardPage.getDomainID() : BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
        DiagramCreationDesccription create = new DiagramCreationDesccription(uri, domainID);
        return create;
    }

    protected boolean openDiagram(Resource diagram) throws PartInitException {
        IWorkbenchPage page;
        StatechartDiagramEditor editor;
        String path = diagram.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile && (editor = (StatechartDiagramEditor)(page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), this.getEditorID())) != null) {
            List allNotationElements = EcoreUtil2.eAllContentsAsList((Resource)diagram);
            for (EObject eObject : allNotationElements) {
                if (!(eObject instanceof View) || !((View)eObject).getType().equals("StateName")) continue;
                IGraphicalEditPart editPart = EditPartUtils.findEditPartForSemanticElement((EditPart)editor.getDiagramGraphicalViewer().getRootEditPart(), (EObject)((View)eObject).getElement());
                if ((editPart = editPart.getChildBySemanticHint("StateName")) == null) continue;
                DirectEditRequest request = new DirectEditRequest();
                request.setDirectEditFeature((Object)BasePackage.Literals.NAMED_ELEMENT__NAME);
                editPart.performRequest((Request)request);
                break;
            }
            return false;
        }
        return false;
    }

    protected String getEditorID() {
        return "org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor";
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean isOpenOnCreate() {
        return this.openOnCreate;
    }

    public void setOpenOnCreate(boolean openOnCreate) {
        this.openOnCreate = openOnCreate;
    }

    protected void setPreferenceHint(PreferencesHint hint) {
        this.preferencesHint = hint;
    }

    public static class DiagramCreationDesccription {
        private URI uri;
        private String domainID;

        public DiagramCreationDesccription(URI uri, String domainID) {
            this.uri = uri;
            this.domainID = domainID;
        }

        public URI getModelURI() {
            return this.uri;
        }

        public String getDomainID() {
            return this.domainID;
        }
    }
}

