/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.ui.hyperlink;

import com.google.inject.Inject;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.adapter.OriginTracing;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.stext.ImportScope;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PackageImportHyperlinkHelper
extends HyperlinkHelper {
    @Inject
    private IPackageImport2URIMapper mapper;
    @Inject
    private StatechartUtil statechartUtil;
    @Inject
    private OriginTracing tracing;

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        this.createPackageImportHyperlinksByOffset(resource, offset, acceptor);
        super.createHyperlinksByOffset(resource, offset, acceptor);
    }

    protected void createPackageImportHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
        if (node != null && node.getGrammarElement() instanceof RuleCall && node.getSemanticElement() instanceof ImportScope) {
            NodeModelUtils.findNodesForFeature((EObject)node.getSemanticElement(), (EStructuralFeature)TypesPackage.Literals.PACKAGE__IMPORTS);
            ImportScope importScope = (ImportScope)node.getSemanticElement();
            EList imports = importScope.getImports();
            for (String pkgImport : imports) {
                Optional mappedImport = this.mapper.findPackageImport((Resource)resource, pkgImport);
                if (!mappedImport.isPresent()) continue;
                acceptor.accept(this.createHyperlink((INode)node, (IPackageImport2URIMapper.PackageImport)mappedImport.get()));
            }
        }
    }

    protected IHyperlink createHyperlink(INode node, IPackageImport2URIMapper.PackageImport pkgImport) {
        XtextHyperlink result = (XtextHyperlink)this.getHyperlinkProvider().get();
        result.setURI(pkgImport.getFileURI());
        Region region = new Region(node.getOffset(), node.getLength());
        result.setHyperlinkRegion(region);
        result.setHyperlinkText(pkgImport.getUri().toString());
        return result;
    }

    public void createHyperlinksTo(XtextResource from, Region region, EObject target, IHyperlinkAcceptor acceptor) {
        super.createHyperlinksTo(from, region, this.getOriginTarget(target), acceptor);
    }

    protected EObject getOriginTarget(EObject target) {
        Type type;
        Iterable originTraces = IterableExtensions.filter((Iterable)this.tracing.getOriginTraces(target), EObject.class);
        Iterator iter = originTraces.iterator();
        if (iter.hasNext()) {
            target = (EObject)iter.next();
        } else if (target instanceof Property && this.statechartUtil.isOriginScope((EObject)(type = ((Property)target).getType()))) {
            target = this.statechartUtil.getOriginScope((EObject)type);
        }
        return target;
    }
}

