/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.ui.tasks;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.DocumentedElement;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.SpecificationElement;
import com.yakindu.sct.model.stext.resource.StextResource;
import com.yakindu.sct.model.stext.tasks.SCTTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.tasks.DefaultTaskFinder;
import org.eclipse.xtext.tasks.ITaskParser;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.tasks.TaskTags;

public class STextTaskFinder
extends DefaultTaskFinder {
    @Inject
    ITaskTagProvider taskTagProvider;
    @Inject
    private ITaskParser parser;

    public List<Task> findTasks(Resource resource) {
        if (resource instanceof StextResource) {
            return this.findTasks((StextResource)resource);
        }
        return super.findTasks(resource);
    }

    public List<Task> findTasks(StextResource resource) {
        TaskTags taskTags = this.taskTagProvider.getTaskTags((Resource)resource);
        ArrayList result = Lists.newArrayList();
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (eObject instanceof SpecificationElement) {
                List<Task> parseTasks = this.parseTasks(eObject, (EStructuralFeature)SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION, taskTags);
                result.addAll(parseTasks);
            }
            if (!(eObject instanceof DocumentedElement)) continue;
            result.addAll(this.parseTasks(eObject, (EStructuralFeature)BasePackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION, taskTags));
        }
        return result;
    }

    protected List<Task> parseTasks(EObject element, EStructuralFeature feature, TaskTags tags) {
        String expression = (String)element.eGet(feature);
        if (expression == null) {
            return Collections.emptyList();
        }
        List tasks = this.parser.parseTasks(expression, tags);
        ArrayList result = Lists.newArrayList();
        for (Task task : tasks) {
            SCTTask sctTask = new SCTTask(task);
            sctTask.setSemanticURI(EcoreUtil.getURI((EObject)element).fragment());
            result.add(sctTask);
        }
        return result;
    }
}

