/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.concepts;

import com.google.inject.Inject;
import com.yakindu.base.types.Event;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.concepts.SubMachine;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions;
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration;
import com.yakindu.sct.model.sgraph.Scope;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EventQueue {
    @Inject
    @Extension
    protected SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    protected ShadowEventExtensions _shadowEventExtensions;
    @Inject
    @Extension
    protected SubMachine _subMachine;
    @Inject
    protected IFlowConfiguration config;

    public boolean requiresEventQueue(ExecutionFlow it) {
        return this.requiresInternalEventQueue(it) || this.requiresIncomingEventQueue(it);
    }

    public boolean isEventDriven(ExecutionFlow flow) {
        return this.config.isEventDriven();
    }

    public boolean requiresIncomingEventQueue(ExecutionFlow it) {
        return this.config.isEventDriven() && (this._sExecExtensions.hasIncomingEvents(it) || this._subMachine.hasReferencedSubmachine(it)) && this.config.applyIncomingEventQueue();
    }

    public boolean requiresInternalEventQueue(ExecutionFlow it) {
        return this.config.isEventDriven() && this._sExecExtensions.hasLocalEvents(it);
    }

    public boolean isQueued(Event it) {
        return this.config.isEventDriven() && (this._sExecExtensions.isLocalEvent(it) && this.config.applyInternalEventQueue() || this._sExecExtensions.isInEvent(it) && this.config.applyIncomingEventQueue() || this._shadowEventExtensions.isShadowEvent(it));
    }

    public boolean hasQueuedEvents(ExecutionFlow it) {
        boolean _isEmpty = IterableExtensions.isEmpty(this.getQueuedEvents(it));
        return !_isEmpty;
    }

    public Iterable<Event> getQueuedEvents(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> this.isQueued((Event)it_1);
        return IterableExtensions.filter(this._sExecExtensions.getAllEvents(it), (Functions.Function1)_function);
    }

    public Iterable<Event> getQueuedEvents(Scope it) {
        Functions.Function1 _function = it_1 -> this.isQueued((Event)it_1);
        return IterableExtensions.filter((Iterable)it.getEvents(), (Functions.Function1)_function);
    }

    public Iterable<Event> withValue(Iterable<Event> it) {
        Functions.Function1 _function = e -> this._sExecExtensions.hasValue(e);
        return IterableExtensions.filter(it, (Functions.Function1)_function);
    }

    public Iterable<Event> withoutValue(Iterable<Event> it) {
        Functions.Function1 _function = e -> {
            boolean _hasValue = this._sExecExtensions.hasValue(e);
            return !_hasValue;
        };
        return IterableExtensions.filter(it, (Functions.Function1)_function);
    }

    public <T> boolean exist(Iterable<T> it) {
        boolean _isEmpty = IterableExtensions.isEmpty(it);
        return !_isEmpty;
    }
}

