/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.naming.tree;

import com.google.inject.Inject;
import com.yakindu.sct.model.sexec.naming.IStringShortener;
import com.yakindu.sct.model.sexec.naming.tree.ShortString;
import com.yakindu.sct.model.sexec.naming.tree.ShortStringUtils;
import com.yakindu.sct.model.sexec.naming.tree.StringTreeNode;
import com.yakindu.sct.model.sexec.naming.tree.TreeServiceNamesValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TreeStringShortener
implements IStringShortener {
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    protected int maxLength = 0;
    @Inject
    @Extension
    protected ShortStringUtils _shortStringUtils;
    @Inject
    protected TreeServiceNamesValidator validator;
    protected StringTreeNode tree;
    protected boolean validState = false;
    protected Map<Object, String> result;
    protected Map<Object, StringTreeNode> storage;
    protected Map<Object, List<String>> originalStrings = CollectionLiterals.newHashMap();

    @Override
    public void reset() {
        this.originalStrings = CollectionLiterals.newHashMap();
        this.validState = false;
    }

    @Override
    public void addString(List<String> s, Object token) {
        Functions.Function1 _function = it -> !Objects.equals(it, token);
        Functions.Function1 _function_1 = it -> IterableExtensions.join((Iterable)this.originalStrings.get(it), (CharSequence)"");
        Functions.Function1 _function_2 = it -> {
            String _join = IterableExtensions.join((Iterable)s, (CharSequence)"");
            return Objects.equals(it, _join);
        };
        boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.originalStrings.keySet(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        if (_exists) {
            String _join = IterableExtensions.join(s, (CharSequence)".");
            String _plus = "String is duplicate: " + _join;
            throw new IllegalArgumentException(_plus);
        }
        this.validState = false;
        this.originalStrings.put(token, s);
    }

    @Override
    public String getString(Object token) {
        boolean _not;
        boolean _containsKey = this.originalStrings.containsKey(token);
        boolean bl = _not = !_containsKey;
        if (_not) {
            return null;
        }
        this.assertValidState();
        return this.result.get(token);
    }

    protected void assertValidState() {
        if (!this.validState) {
            this.result = CollectionLiterals.newHashMap();
            this.storage = CollectionLiterals.newHashMap();
            if (this.maxLength == 0) {
                Consumer<Object> _function = token -> this.result.put(token, IterableExtensions.join((Iterable)this.originalStrings.get(token)));
                this.originalStrings.keySet().forEach(_function);
            } else {
                this.buildTree();
                this.shortenNames();
            }
            this.validState = true;
        }
    }

    protected void buildTree() {
        StringTreeNode _stringTreeNode;
        this.tree = _stringTreeNode = new StringTreeNode();
        this.storage = CollectionLiterals.newHashMap();
        Consumer<Object> _function = token -> this.storage.put(token, this.tree.addStringList(this.originalStrings.get(token)));
        this.originalStrings.keySet().forEach(_function);
        this.tree.compress();
    }

    protected void shortenNames() {
        ArrayList nodes = CollectionLiterals.newArrayList();
        HashMap map = CollectionLiterals.newHashMap();
        HashMap endNodeShortStrings = CollectionLiterals.newHashMap();
        HashMap shortStrings = CollectionLiterals.newHashMap();
        List<StringTreeNode> _endNodes = this.tree.getEndNodes();
        for (StringTreeNode node : _endNodes) {
            ArrayList list = CollectionLiterals.newArrayList();
            list.add(node);
            nodes.add(list);
            map.put(node, list);
            endNodeShortStrings.put(node, CollectionLiterals.newArrayList());
        }
        this.buildIndividualNames(nodes);
        Consumer<StringTreeNode> _function = node_1 -> {
            Functions.Function1 _function_1 = it -> this._shortStringUtils.toShortString((StringTreeNode)it, shortStrings);
            ((List)endNodeShortStrings.get(node_1)).addAll(ListExtensions.map((List)((List)map.get(node_1)), (Functions.Function1)_function_1));
        };
        map.keySet().forEach(_function);
        ArrayList shortStringLists = CollectionLiterals.newArrayList((Object[])((List[])Conversions.unwrapArray(endNodeShortStrings.values(), List.class)));
        this.calculateShortNames(shortStringLists);
        Consumer<Object> _function_1 = token -> this.result.put(token, this._shortStringUtils.join((List)endNodeShortStrings.get(this.storage.get(token))));
        this.storage.keySet().forEach(_function_1);
    }

    public void calculateShortNames(List<List<ShortString>> names) {
        this.validator.names = names;
        List<ShortString> longest = this._shortStringUtils.getLongestElement(names);
        while (this._shortStringUtils.getLength(longest) > this.maxLength && this.cutOneCharacter(longest)) {
            longest = this._shortStringUtils.getLongestElement(names);
        }
    }

    public boolean cutOneCharacter(List<ShortString> strings) {
        ShortString toCut = null;
        int cheapestCut = Integer.MAX_VALUE;
        for (ShortString part : strings) {
            int oldCost = part.getCutCost();
            part.removeCheapestChar();
            int _cutCost = part.getCutCost();
            int costDifference = _cutCost - oldCost;
            if (this.validator.validate() && costDifference > 0 && costDifference < cheapestCut) {
                toCut = part;
                cheapestCut = costDifference;
            }
            part.rollback();
        }
        if (toCut != null) {
            toCut.removeCheapestChar();
        }
        return toCut != null;
    }

    protected void buildIndividualNames(List<List<StringTreeNode>> nodes) {
        HashMap map = CollectionLiterals.newHashMap();
        for (List<StringTreeNode> list : nodes) {
            boolean _not;
            String name = this.toString(list);
            boolean _containsKey = map.containsKey(name);
            boolean bl = _not = !_containsKey;
            if (_not) {
                map.put(name, CollectionLiterals.newArrayList());
            }
            ((List)map.get(name)).add(list);
        }
        boolean abort = true;
        Collection _values = map.values();
        for (List outer : _values) {
            boolean _greaterThan;
            int _size = outer.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            abort = false;
            for (List inner : outer) {
                StringTreeNode parent = ((StringTreeNode)inner.get((int)0)).parent;
                if (parent == null) continue;
                inner.add(0, parent);
            }
        }
        if (abort) {
            return;
        }
        this.buildIndividualNames(nodes);
    }

    protected String toString(List<StringTreeNode> list) {
        String _xblockexpression = null;
        StringBuilder sb = new StringBuilder();
        for (StringTreeNode node : list) {
            sb.append(node.data);
        }
        _xblockexpression = sb.toString();
        return _xblockexpression;
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

