/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.transformation.config;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class DefaultFlowConfiguration
implements IFlowConfiguration {
    @Inject
    @Extension
    protected StatechartAnnotations _statechartAnnotations;
    protected boolean _isEventDriven = false;
    protected boolean _isSuperStep = false;
    protected boolean _applyIncomingEventBuffer = true;
    protected boolean _applyInternalEventBuffer = true;
    protected boolean _applyOutgoingEventBuffer = false;
    protected boolean _applyIncomingEventQueue = true;
    protected boolean _applyInternalEventQueue = true;
    protected boolean isConfigured = false;

    @Override
    public void defineConfigurationForStatechart(Statechart sc) {
        if (!this.isConfigured) {
            this.configureForStatechart(sc);
            this.isConfigured = true;
        }
    }

    protected void configureForStatechart(Statechart sc) {
        this._isEventDriven = this._statechartAnnotations.isEventDriven(sc);
        this._isSuperStep = this._statechartAnnotations.isSuperStep(sc);
        this._applyIncomingEventBuffer = this._statechartAnnotations.isInEventBuffer(sc);
        this._applyInternalEventBuffer = this._statechartAnnotations.isInternalEventBuffer(sc);
        this._applyIncomingEventQueue = this._statechartAnnotations.isInEventBuffer(sc);
        this._applyInternalEventQueue = this._statechartAnnotations.isInternalEventBuffer(sc);
    }

    @Override
    public boolean applyIncomingEventBuffer() {
        return this.isCycleBased() && this._applyIncomingEventBuffer;
    }

    @Override
    public boolean applyInternalEventBuffer() {
        return this.isCycleBased() && this._applyInternalEventBuffer;
    }

    @Override
    public boolean applyOutgoingEventBuffer() {
        return this._applyOutgoingEventBuffer;
    }

    @Override
    public boolean isCycleBased() {
        return !this._isEventDriven;
    }

    @Override
    public boolean isEventDriven() {
        return this._isEventDriven;
    }

    @Override
    public boolean isSuperStep() {
        return this._isSuperStep;
    }

    @Override
    public boolean applyIncomingEventQueue() {
        return this.isEventDriven() && this._applyIncomingEventQueue;
    }

    @Override
    public boolean applyInternalEventQueue() {
        return this.isEventDriven() && this._applyInternalEventQueue;
    }

    @Singleton
    public static class AllFeaturesDisabled
    extends DefaultFlowConfiguration {
        @Override
        public void configureForStatechart(Statechart sc) {
            super.configureForStatechart(sc);
            this._applyIncomingEventBuffer = false;
            this._applyInternalEventBuffer = false;
            this._applyOutgoingEventBuffer = false;
            this._applyIncomingEventQueue = false;
        }
    }
}

