/**
 * Copyright (c) 2019-2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Rene Beckmann - itemis AG
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 *
 */
package com.yakindu.yet.sct.generator.c;

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.files.MetaHeader
import com.yakindu.sct.generator.c.files.MetaSource
import com.yakindu.sct.generator.c.files.RxCHeader
import com.yakindu.sct.generator.c.files.RxCSource
import com.yakindu.sct.generator.core.IExecutionFlowGenerator
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess.*

class CYetGenerator implements IExecutionFlowGenerator {

	@Inject extension ICoreLibraryHelper
	@Inject protected extension FileNaming
	@Inject extension YETNaming

	@Inject extension YetHeader yetHeader
	@Inject extension YetSource yetSource

	@Inject extension StatechartTracerHeader traceHeader
	@Inject extension StatechartTracerSource traceSource

	@Inject extension YetTraceHeader yetTraceHeader
	@Inject extension YetTraceSource yetTraceSource
	
	@Inject extension MetaHeader scMetaHeader
	@Inject extension MetaSource scMetaSource
	
	@Inject extension RxCHeader scRxcHeader
	@Inject extension RxCSource scRxcSource

	@Inject IGenArtifactConfigurations configs

	override generate(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
		initGenerationArtifacts(flow, entry, configs)
		
		fsa.generateFile(rxcModule.c, entry.libraryOutput, scRxcSource.content(flow, entry, configs))
		fsa.generateFile(rxcModule.h, entry.libraryOutput, scRxcHeader.content(flow, entry, configs))
		fsa.generateFile(yetModule.c, entry.libraryOutput, yetSource.content(flow, entry, configs))
		fsa.generateFile(yetModule.h, entry.libraryOutput, yetHeader.content(flow, entry, configs))
		fsa.generateFile(yetTracerModule.c, entry.libraryOutput, yetTraceSource.content(flow, entry, configs))
		fsa.generateFile(yetTracerModule.h, entry.libraryOutput, yetTraceHeader.content(flow, entry, configs))
		fsa.generateFile(flow.tracerModule.c, entry.headerOutput, traceSource.content(flow, entry, configs))
		fsa.generateFile(flow.tracerModule.h, entry.headerOutput, traceHeader.content(flow, entry, configs))
		fsa.generateFile(flow.metaModule.c, entry.headerOutput, scMetaSource.content(flow, entry, configs))
		fsa.generateFile(flow.metaModule.h, entry.headerOutput, scMetaHeader.content(flow, entry, configs))
	}

	def protected getLibraryOutput(GeneratorEntry entry) {
		if (entry.libraryTargetFolderValue !== null) {
			LIBRARY_TARGET_FOLDER_OUTPUT
		} else {
			entry.headerOutput
		}
	}

	def protected getHeaderOutput(GeneratorEntry entry) {
		if (entry.apiTargetFolderValue !== null) {
			API_TARGET_FOLDER_OUTPUT
		} else {
			TARGET_FOLDER_OUTPUT
		}
	}

	def protected initGenerationArtifacts(ExecutionFlow flow, GeneratorEntry entry,
		IGenArtifactConfigurations locations) {
			
		locations.configure(yetModule.c, entry.libraryOutput, yetSource)
		locations.configure(yetModule.h, entry.libraryOutput, yetHeader)
		locations.configure(yetTracerModule.c, entry.libraryOutput, yetTraceSource)
		locations.configure(yetTracerModule.h, entry.libraryOutput, yetTraceHeader)
		locations.configure(flow.tracerModule.c,entry.headerOutput, traceSource)
		locations.configure(flow.tracerModule.h,entry.headerOutput, traceHeader)
		locations.configure(flow.metaModule.c,entry.headerOutput, scMetaSource)
		locations.configure(flow.metaModule.h,entry.headerOutput, scMetaHeader)
		locations.configure(flow.module.client.h,entry.headerOutput, scMetaHeader)

		// also configure required resources  
		locations.configure(typesModule.h, entry.libraryOutput, null)
		locations.configure(rxcModule.h, entry.libraryOutput, null)
		locations.configure(rxcModule.c, entry.libraryOutput, null)
		locations.configure(tracingModule.h, entry.libraryOutput, null)
		locations.configure(flow.module.c,entry.headerOutput, null)
		locations.configure(flow.module.h,entry.headerOutput, null)		
	}
	


}
