/**
 * Copyright (c) 2019-2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Rene Beckmann - itemis AG
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 *
 */
package com.yakindu.yet.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class StatechartTracerHeader implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntries
	@Inject protected extension FileNaming
	@Inject extension YETNaming yetNaming
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
			«entry.licenseText»
			
			
			#ifndef «flow.module.define»_TRACER_H_
			#define «flow.module.define»_TRACER_H_
			
			
			«includes(flow, entry, locations)»
			
			
			#ifdef __cplusplus
			extern "C"
			{
			#endif
			
			
			«declarations(flow, entry, locations)»
			
			
			#ifdef __cplusplus
			}
			#endif
			
			
			#endif /* «flow.module.define»_TRACER_H_ */
		'''
	}
	
	def protected includes(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations){
		'''
			#include "«(yetTracerModule.h).relativeTo(flow.tracerModule.h)»"
			
			
			#include "«(flow.module.h).relativeTo(flow.tracerModule.h)»"
			#include "«(flow.metaModule.h).relativeTo(flow.tracerModule.h)»"
		'''
	}
	
	def protected declarations(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations){
		'''		
			extern void «functionPrefixStatechart(flow)»_init_sc_tracer(yet_sc_tracer *tracer, «flow.statemachine»* machine, sc_string name);
		'''
	}
	
}
