/**
 * Copyright (c) 2019-2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Rene Beckmann - itemis AG
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 *
 */
 package com.yakindu.yet.sct.generator.c

import com.google.inject.Inject
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.DefaultNamingService
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.stext.stext.InterfaceScope
import org.eclipse.xtext.naming.IQualifiedNameProvider

import static com.yakindu.yet.core.format.YETConstants.*

class YETNaming extends DefaultNamingService{
	@Inject protected extension SExecExtensions
	@Inject protected extension IQualifiedNameProvider
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension INamingService
	@Inject protected extension Naming
	@Inject protected extension FileNaming

	protected static final String MESSAGE_STRUCT_NAME = "yet_message"
	protected static final String MESSAGE_ENUM_NAME = "yet_message_type"
	protected static final String YET_SEND_NAME = "yet_send"
	protected static final String TIME_EVENT_RAISE_FUNCTION = "yet_time_event_raise"
	protected static final String TIME_EVENT_SET_FUNCTION = "yet_time_event_set"
	protected static final String TIME_EVENT_UNSET_FUNCTION = "yet_time_event_unset"
	protected static final String TIME_EVENT_INDEX = "yet_time_event_index"
	
	public static final String UPDATE_BEGIN = "YET_MESSAGE_UPDATE_BEGIN";
	public static final String INIT_BEGIN = "YET_MESSAGE_INIT_BEGIN";
	public static final String ERR_BEGIN_INVALID = "YET_ERR_INVALID_BEGIN";
	public static final String ERR_MSG_INVALID = "YET_ERR_INVALID_MSG";
	public static final String ERR_MISSING_VALUE = "YET_ERR_MISSING_VALUE";
	public static final String ERR_NULLPTR = "YET_ERR_NULLPTR";
	public static final String ERR_TIMESTAMP_INVALID = "YET_ERR_INVALID_TIMESTAMP";
	public static final String ERR_KEY_INVALID = "YET_ERR_INVALID_KEY";
	public static final String ERR_VALUE_INVALID = "YET_ERR_INVALID_VALUE";
	public static final String MSG_SEPARATOR = "YET_MESSAGE_SEPARATOR";
	
	def CharSequence statechartName(ExecutionFlow it){
		it.fullyQualifiedName.toString
	}
	
	def CharSequence functionPrefixStatechart(ExecutionFlow it){
		it.statechartName.toString.asIdentifier.toFirstLower
	}
	
	def CharSequence statemachine(ExecutionFlow it){
		it.statechartName.toString.asIdentifier.toFirstUpper
	}
	
	def CharSequence filePrefix(ExecutionFlow it){
		it.statechartName.toString.asIdentifier.toFirstUpper
	}
	
	def CharSequence headerPrefix(ExecutionFlow it){
		it.statechartName.toString.asIdentifier.toUpperCase
	}
	
	def CharSequence yetName(Declaration it) {
		val scope = scope
		if (scope instanceof InterfaceScope) {
			if (!(scope as InterfaceScope).name.nullOrEmpty) {
				return '''«scope.name».«name»'''
			}
		}
		return '''«name»'''
	}

	def CharSequence yetName(ExecutionState it) {
		fullyQualifiedName.skipFirst(2).toString
	}

	def CharSequence stateEntered() {
		STATE_ENTER
	}

	def CharSequence stateExited() {
		STATE_EXIT
	}

	def CharSequence start() {
		START_KEY
	}

	def CharSequence runCycleStart() {
		RUNCYCLE_START
	}

	def CharSequence runCycleEnd() {
		RUNCYCLE_END
	}
	
	def CharSequence eventLoopStart() {
		EVENT_LOOP_START
	}

	def CharSequence eventLoopEnd() {
		EVENT_LOOP_END
	}

	def CharSequence timeEventSet() {
		TIME_EVENT_SET
	}

	def CharSequence timeEventUnset() {
		TIME_EVENT_UNSET
	}

	def CharSequence timeEventExpire() {
		TIME_EVENT_EXPIRE
	}
	
	def CharSequence clearInEvents() {
		CLEAR_IN_EVENTS
	}
	
	def CharSequence clearOutEvents() {
		CLEAR_OUT_EVENTS
	}
	
	def CharSequence yetStatechartNameConstant(ExecutionFlow it) {
		'''«name.asEscapedIdentifier»_name'''
	}

	def valueConverterFunctionName(TypeSpecifier it) {
		valueConverterFunctionName(targetLanguageName)
	}

	def valueConverterFunctionName(CharSequence typeName) {
		'''yet_convert_«typeName»_tostring'''
	}

	def yetMessageEnum() { MESSAGE_ENUM_NAME }

	def yetMessageStruct() { MESSAGE_STRUCT_NAME }

	def yetSend() { YETNaming.YET_SEND_NAME }
	
	def timeEventRaiseFunction() {TIME_EVENT_RAISE_FUNCTION}
	
	def timeEventSetFunction() {TIME_EVENT_SET_FUNCTION}
	
	def timeEventUnsetFunction() {TIME_EVENT_UNSET_FUNCTION}

	def timeEventIndex(ExecutionFlow it) {functionPrefix + TIME_EVENT_INDEX }
	
	def timeEventFQName(ExecutionFlow it, TimeEvent tev) {
		'''@tev.«flow.timeEvents.indexOf(tev)»'''
	}
	
	def skipYETMessage() {
		'''skip_yet_send'''
	}
	
	def meta(ExecutionFlow it, CharSequence feature) {
		'''@«feature»'''
	}
	
	def yetScope() {"yet_scope"}
	
	def yetScopeDispatch() {"yet_scope_dispatch"}
	
	def yetScopedMessage() {"yet_create_scoped_message"}
	
	def yetCurrentTimestamp() {"get_current_timestamp"}
	
	def tracerModule(ExecutionFlow it) {
		module + "_tracer"
	}
	
	def yetModule() { "sc_yet" }
	
	def yetTracerModule() { "yet_sc_tracer" }
}
