/**
 * Copyright (c) 2019-2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Rene Beckmann - itemis AG
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 *
 */
package com.yakindu.yet.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.yet.core.format.YETConstants

class YetHeader implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntries
	@Inject protected extension FileNaming
	@Inject extension YETNaming
	
	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		'''
			«entry.licenseText»
			
			#ifndef SC_YET_H
			#define SC_YET_H
			
			«includes(entry, locations)»
			
			#ifdef __cplusplus
			extern "C" {
			#endif
			
			«defines»
			
			«declarations»
			
			#ifdef __cplusplus
			}
			#endif
			
			#endif
		'''
	}
	
	def includes(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations locations){
		'''
			#include <stddef.h>
			#include "«(typesModule.h).relativeTo(yetModule.h)»"
			#include "«(rxcModule.h).relativeTo(yetModule.h)»"
		'''
	}

	def defines() { '''
			#define YET_MESSAGE_INIT_BEGIN '«YETConstants::INIT_BEGIN»'
			#define YET_MESSAGE_UPDATE_BEGIN '«YETConstants::UPDATE_BEGIN»'
			#define YET_MESSAGE_SEPARATOR '«YETConstants::DELIMITER»'
			#define YET_ERR_INVALID_MSG 1
			#define YET_ERR_INVALID_BEGIN 2
			#define YET_ERR_INVALID_TIMESTAMP 4
			#define YET_ERR_INVALID_KEY 8
			#define YET_ERR_INVALID_VALUE 16
			#define YET_ERR_MISSING_VALUE 32
			#define YET_ERR_NULLPTR 64
			
			#ifndef YET_SCOPE_SEND_BUF_LEN
			#define YET_SCOPE_SEND_BUF_LEN 255
			#endif
		'''
	}
	
	def declarations(ExecutionFlow it){'''
			enum yet_message_type {
				INIT,
				UPDATE
			};
			
			typedef uint64_t yet_timestamp;
			typedef uint32_t yet_msize;
			typedef uint16_t yet_error;
			
			typedef struct yet_message yet_message;
			
			struct yet_message {
				enum yet_message_type type;
				yet_timestamp timestamp;
				char* key;
				char* value;
			};
			
			/*! Determines the length of a yet_message in string representation. */
			extern yet_msize yet_message_len(yet_message* msg);
			
			
			typedef struct yet_scope yet_scope;
			
			/**
			 * When a scope is matched, its handler is called.
			 * The handler should return 0 on success.
			 */
			typedef yet_error (*yet_handler)(yet_scope* scope, yet_message *msg, char *fqn);
			
			struct yet_scope {
				yet_scope *parent_scope;
				yet_scope **child_scopes;
				sc_integer num_child_scopes;
				sc_string name;
				yet_handler handler;
				void* instance;
			
				sc_single_subscription_observer_sc_string   message_receiver;
				sc_observable_sc_string trace_messages;
			
			};
			
			
			/*
			 * This function is called by tracing state machines.
			 */
			extern void yet_scope_send(yet_scope* self, struct yet_message * msg);
			
			/*!
			 * If a message was received, call this function to process it.
			 */
			extern void yet_scope_accept_message(yet_scope *scope, char *text);
			
			extern void yet_scope_dispatch_message(yet_scope* scope, yet_message* msg, char *fqn);
			
			extern char* yet_scope_create_message(yet_scope* scope, char* msg, char* dst, sc_boolean meta);
			
			extern void yet_scope_init(yet_scope* scope, yet_scope* parent_scope, yet_scope** child_scopes, sc_integer num_child_scopes, char *name, yet_handler handler, void* instance);
			
			
			typedef char* (*yet_value_serializer)(const void* from, char* to);
			
			yet_value_serializer yet_int_serializer_function(size_t size, sc_boolean is_signed);
			yet_value_serializer yet_real_serializer_function(size_t size);
			
			extern char* yet_serialize_void(const void* from, char* to);
			extern char* yet_serialize_bool(const void* from, char* to);
			extern char* yet_serialize_float(const void* from, char* to);
			extern char* yet_serialize_double(const void* from, char* to);
			extern char*  yet_serialize_string(const void* from, char* to);
			extern char* yet_serialize_int_8(const void* from, char* to);
			extern char* yet_serialize_int_16(const void* from, char* to);
			extern char* yet_serialize_int_32(const void* from, char* to);
			extern char* yet_serialize_int_64(const void* from, char* to);
			extern char* yet_serialize_uint_8(const void* from, char* to);
			extern char* yet_serialize_uint_16(const void* from, char* to);
			extern char* yet_serialize_uint_32(const void* from, char* to);
			extern char* yet_serialize_uint_64(const void* from, char* to);
			
			/* ================================================
			 * Functions that need to be implemented by clients
			 */		
			
			/*! Function to retrieve the current timestamp (in milliseconds). */
			extern yet_timestamp yet_current_timestamp(void);
			
		'''}
	
}
