/**
 * Copyright (c) 2019-2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Rene Beckmann - itemis AG
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 *
 */
package com.yakindu.yet.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class YetTraceHeader implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntries
	@Inject protected extension FileNaming
	@Inject extension YETNaming
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
			«entry.licenseText»
			
			
			#ifndef YET_SC_TRACER_H_
			#define YET_SC_TRACER_H_
			
			
			«includes(flow, entry, locations)»
			
			
			#ifdef __cplusplus
			extern "C" {
			#endif
			
			
			«declarations(flow, entry, locations)»
			
			
			#ifdef __cplusplus
			}
			#endif
			
			
			#endif /* YET_SC_TRACER_H_ */
		'''
	}
	
	def protected includes(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations){
		'''
			#include "«(tracingModule.h).relativeTo(yetTracerModule.h)»"
			#include "«(yetModule.h).relativeTo(yetTracerModule.h)»"
		'''
	}
	
	def protected declarations(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations){
		'''
			typedef void * sc_machine_ptr;
			
			typedef struct {
				char* (*featureName)(sc_integer);
				char* (*featureValue)(sc_integer, const void*, char*);
				char* (*stateName)(sc_integer);
			} yet_sc_trace_info_provider;
			
			
			typedef struct {
				sc_trace_handler traceEventHandler;
				yet_scope scope;
				yet_sc_trace_info_provider traceinfoProvider;
				sc_machine_ptr machine;
			
				sc_integer skip_raised_in_event; /* TODO : check if we can omit this hack */
				sc_boolean is_running; /* TODO: eliminate this - it is semantically incorrect */
			} yet_sc_tracer ;
			
			extern void yet_init_sc_tracer(yet_sc_tracer *tracer, sc_machine_ptr machine, yet_handler actor);
		'''
	}
	
}
