/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.base

import com.google.inject.Inject
import com.google.inject.Injector
import com.yakindu.sct.model.sruntime.ExecutionSlot
import com.yakindu.base.types.Event
import com.yakindu.base.expressions.interpreter.types.EventInstance
import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.xtend.lib.annotations.Accessors
import org.eclipse.emf.ecore.EObject

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*
import com.yakindu.sct.model.sruntime.ExecutionEvent

/**
 * Defines event semantics.
 * 
 * @author axel terfloth - Initial contribution and API  * 
 */
class EventSemantics {
	@Inject protected extension Injector
	@Inject(optional = true) protected IInterpreter.Context instanceContext
	
	def void adaptEvent(ExecutionEvent it, IInterpreter.Event inst) {
		it.eAdapters += new EventInstanceAdapter() => [
			eventInstance = inst
		]
	} 
	
	def void adaptEvent(ExecutionEvent it, Event event) {
		if ( instanceContext !== null)
			adaptEvent(createEventInstance(it, event))
	} 
	
	def dispatch IInterpreter.Event eventInstance(Object it) {
		throw new InterpreterException("Cannot cannot provide event for: " + it);
	}

	def dispatch IInterpreter.Event eventInstance(EObject it) {
		eContainer?.eventInstance
	}

	def dispatch IInterpreter.Event eventInstance(ExecutionSlot it) {
		val adapter = it.getExistingAdapter(EventInstanceAdapter)
		if(adapter !== null) 
			(adapter as EventInstanceAdapter).eventInstance
		else 
			null
	}
	
	def protected IInterpreter.Event createEventInstance(ExecutionEvent slot, Event event) {
		new EventInstance => [
			it.injectMembers
			it.setUp(slot, event, instanceContext)
		]
	}
	
	static class EventInstanceAdapter extends AdapterImpl {
		@Accessors IInterpreter.Event eventInstance

		override isAdapterForType(Object type) {
			return type == EventInstanceAdapter
		}
	}
	
}