/**
 * Copyright (c) 2020-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.base

import com.yakindu.base.expressions.interpreter.base.IInterpreter.Instance
import com.yakindu.sct.model.sruntime.CompositeSlot
import com.yakindu.sct.model.sruntime.ExecutionArgument
import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtend.lib.annotations.Accessors

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*
import com.yakindu.sct.model.sruntime.ReferenceSlot

/**
 * Defines how access and interact with runtime instances.
 * 
 * @author axel terfloth - Initial contribution and API  * 
 */
class InstanceSemantics {

	public static String SELF_NAME = "_self_"
	
	def void adaptInstance(EObject it, Instance inst) {
		it.eAdapters += new InstanceAdapter() => [
			instance = inst
		]
	} 
	
	def dispatch IInterpreter.Instance instance(Object it) {
		throw new InterpreterException("Cannot cannot provide instance for: " + it);
	}

	def dispatch IInterpreter.Instance instance(EObject it) {
		eContainer?.instance
	}

	def dispatch IInterpreter.Instance instance(CompositeSlot it) {
		val adapter = it.getExistingAdapter(InstanceAdapter)
		if(adapter !== null) 
			(adapter as InstanceAdapter).instance
		else 
			eContainer?.instance
	}
	
	def dispatch IInterpreter.Instance instance(ExecutionArgument it) {
		if (value instanceof ReferenceSlot) {
			(value as ReferenceSlot).reference.instance
		}
		else if ( value instanceof EObject ) {
			value.instance
		}
		else null
	}
	
	static class InstanceAdapter extends AdapterImpl {
		@Accessors Instance instance

		override isAdapterForType(Object type) {
			return type == InstanceAdapter
		}

	}
	
}