/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.base

import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtend.lib.annotations.Accessors

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

/**
 *  
 * @author axel terfloth  - Initial contribution
 */
class InterpreterAdapter extends AdapterImpl {
	
	@Accessors IInterpreter interpreter
	
	override isAdapterForType(Object type) {
		return type == InterpreterAdapter
	}
	
	static def void adaptInterpreter(EObject it, IInterpreter i) {
		it.eAdapters += new InterpreterAdapter() => [
			interpreter = i
		]
	} 
	
	static def IInterpreter interpreter(EObject it) {
		val adapter = it.getRootContainer.getExistingAdapter(InterpreterAdapter)
		
		if(adapter !== null) 
			(adapter as InterpreterAdapter).interpreter
		else 
			null
	}
	
}