/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.base

import com.yakindu.sct.model.sruntime.ExecutionSlot
import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtend.lib.annotations.Accessors
import com.yakindu.base.types.Property

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*
import com.google.inject.Singleton
import com.yakindu.base.expressions.interpreter.types.PropertyInstance
import com.google.inject.Injector
import com.google.inject.Inject

/**
 * Defines property semantics.
 * 
 * @author axel terfloth - Initial contribution and API  * 
 */
@Singleton
class PropertySemantics {

	@Inject protected extension Injector
	@Inject(optional = true) protected IInterpreter.Context instanceContext
	
	def void adaptProperty(ExecutionSlot it, IInterpreter.Property inst) {
		it.eAdapters += new PropertyInstanceAdapter() => [
			propertyInstance = inst
		]
	} 
	
	def void adaptProperty(ExecutionSlot it, Property prop) {
		if ( instanceContext !== null)
			adaptProperty(createPropertyInstance(it, prop))
	} 
	
	def dispatch IInterpreter.Property property(Object it) {
		throw new InterpreterException("Cannot cannot provide property for: " + it);
	}

	def dispatch IInterpreter.Property property(EObject it) {
		eContainer?.property
	}

	def dispatch IInterpreter.Property property(ExecutionSlot it) {
		val adapter = it.getExistingAdapter(PropertyInstanceAdapter)
		if(adapter !== null) 
			(adapter as PropertyInstanceAdapter).propertyInstance
		else 
			null
	}
	
	def protected IInterpreter.Property createPropertyInstance(ExecutionSlot slot, Property prop) {
		new PropertyInstance => [
			it.injectMembers
			it.setUp(slot, prop, instanceContext)
		]
	}
	
	static class PropertyInstanceAdapter extends AdapterImpl {
		@Accessors IInterpreter.Property propertyInstance

		override isAdapterForType(Object type) {
			return type == PropertyInstanceAdapter
		}
	}
}