/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.base

import com.yakindu.sct.model.sruntime.CompositeSlot

/**
 * Provides access to interpreter runtime concepts
 */
class SRuntimeConcepts {
	
	def CompositeSlot globalsSlot(IInterpreter.Context it) {
		heap.compositeSlotByName(SRuntimeInterpreter.GLOBALS_SLOT_NAME)
	} 

	def CompositeSlot jobsSlot(IInterpreter.Context it) {
		heap.compositeSlotByName(SRuntimeInterpreter.JOBS_SLOT_NAME)
	} 
	
	def CompositeSlot compositeSlotByName(Object it, String name) {
		if (it instanceof CompositeSlot) {
			val slot = it.slots.findFirst[ it.name == name]
			if  (slot instanceof CompositeSlot)
				return slot
		}
		null
	}
}