/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.base

import com.yakindu.base.expressions.interpreter.CoreFunction
import com.yakindu.base.expressions.interpreter.Function.FunctionMethod
import com.yakindu.sct.model.sruntime.ReferenceSlot

/**
 * CoreFunction extension which covers interpreter types. 
 * 
 * @author axel terfloth
 */
class SRuntimeFunction extends CoreFunction {
	
	
	@FunctionMethod(EQUALS) 
	def Object equals(ReferenceSlot leftValue, ReferenceSlot rightValue) {
		return leftValue.reference === rightValue.reference
	}
		
	@FunctionMethod(NOT_EQUALS) 
	def Object notEquals(ReferenceSlot leftValue, ReferenceSlot rightValue) {
		return leftValue.reference !== rightValue.reference
	}
	
	@FunctionMethod(EQUALS) 
	def Object equals(ReferenceSlot leftValue, IInterpreter.Null rightValue) {
		return leftValue.reference === null
	}
		
	@FunctionMethod(NOT_EQUALS) 
	def Object notEquals(ReferenceSlot leftValue, IInterpreter.Null rightValue) {
		return leftValue.reference !== null
	}

	@FunctionMethod(EQUALS) 
	def Object equals(IInterpreter.Null leftValue, ReferenceSlot rightValue) {
		return null === rightValue.reference
	}
		
	@FunctionMethod(NOT_EQUALS) 
	def Object notEquals(IInterpreter.Null leftValue, ReferenceSlot rightValue) {
		return null !== rightValue.reference
	}
	
	@FunctionMethod(EQUALS) 
	def Object equals(IInterpreter.Null leftValue, IInterpreter.Null rightValue) {
		return true
	}
		
	@FunctionMethod(NOT_EQUALS) 
	def Object notEquals(IInterpreter.Null leftValue, IInterpreter.Null rightValue) {
		return false
	}
		
}