/**
 * Copyright (c) 2022-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.types

import com.yakindu.base.expressions.interpreter.base.IInstanceFactory
import com.yakindu.base.expressions.interpreter.base.IInterpreter
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Package
import com.yakindu.sct.model.sruntime.CompositeSlot

import static extension org.eclipse.xtext.EcoreUtil2.*
import com.yakindu.base.types.Operation
import java.util.Optional

/**
 * 
 * @author axel terfloth
 */
class ComplexTypeInstance extends RuntimeInstance {
	
	protected ComplexType declarator
	
	def void setUp(CompositeSlot instance, ComplexType declarator, IInterpreter.Context context, IInstanceFactory factory) {
		super.setUp(instance, context, factory)		
		this.declarator = declarator 
	}
		
	override declarationPackage() { declarator.getContainerOfType(Package) }
	
	override declarations() { declarator.allFeatures }	
	
	/** 
	 * Return the method implementation for the operation based on the concrete type. The most concrete implementation will be used. 
	 */
	override protected implementationOperation(Operation it) {
		return declarator.method(it)
	}
	
	def protected Optional<Operation> method(ComplexType type, Operation op) {
		val method = type
			.features
			.filter(Operation)
			.findFirst[ op.name == it.name]
		
		if (method !== null) {
			return Optional.of(method)
		}
		
		return type
					.superTypes
					.map[type]
					.filter(ComplexType)
					.map[method(op)]
					.findFirst[!it.empty]
	}
	
}
