/**
 * Copyright (c) 2022-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.types

import com.google.inject.Inject
import com.itemis.create.base.model.bindings.PropertyChangedNotification
import com.yakindu.base.expressions.interpreter.base.IInterpreter
import com.yakindu.base.expressions.interpreter.base.ValueSemantics
import com.yakindu.base.types.Property
import com.yakindu.sct.model.sruntime.ExecutionSlot
import com.yakindu.base.expressions.interpreter.base.InterpreterException

/**
 * Implements property set and update notification behavior. 
 * 
 * @author axel terfloth
 */
class PropertyInstance implements IInterpreter.Property {

	@Inject protected extension ValueSemantics
	@Inject protected extension PropertyChangedNotification
	
	protected extension IInterpreter.Context context
	protected ExecutionSlot slot
	protected Property property

	def void setUp(ExecutionSlot propSlot, Property prop, IInterpreter.Context context) {
		this.context = context
		this.property = prop
		this.slot = propSlot
	}
		
	override get() {
		throw new UnsupportedOperationException("TODO: should not be used yet")
	}
	
	override set(Object value) {
		setValue(slot, value)
		notifyPropertyChange(value)
	}
	
	def protected notifyPropertyChange(Object value) {
		val notifications = property.changedNotifications
		if (!notifications.empty) {
			notifications.forEach[
				val propertyOwner = slot.instance
				
				_try("notifyPropertyChanged " + property.name, [
					propertyOwner.invoke(slot, it)
				], [ onError |
					throw new InterpreterException(onError)
				])
			]
		}
	}

}
