/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation
import com.itemis.create.base.generator.core.concepts.TimedInterface
import com.itemis.create.base.generator.core.concepts.TimerService
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.types.resource.Statechart2TypeTransformation

/**
 * @author laszlo kovacs - Initial contribution.
 */
class StatemachineProperties {
	
	public static final String MAX_ORTHOGONAL_STATES = "maxOrthogonalStates"
	public static final String MAX_HISTORY_STATES = "maxHistoryStates"

	@Inject protected extension StatemachineClass
	protected extension TypesFactory = TypesFactory.eINSTANCE
	protected extension ExpressionsFactory eFactory = ExpressionsFactory.eINSTANCE
	@Inject protected extension StateEnum
	@Inject protected extension SExecExtensions
	@Inject protected extension TypeBuilder
	@Inject protected extension Documentation
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension IMethodCode
	@Inject protected extension ExpressionBuilder
	@Inject protected extension StatemachineFunctions
	@Inject protected extension OriginTracing
	@Inject protected extension TimerService
	@Inject protected extension TimedInterface
	@Inject protected extension EventQueue
	@Inject protected extension RunCycleMethod
	@Inject protected extension Statechart2TypeTransformation
	@Inject protected extension InternallyDefinedTypeAnnotation
	@Inject protected extension SubMachine
	
	def orthogonalStatesConst() {
		MAX_ORTHOGONAL_STATES
	}

	def historyStatesConst() {
		MAX_HISTORY_STATES
	}

	def void defineProperties(ExecutionFlow flow) {
		val smClass = flow.stateMachineClass

		flow.getProperties.forEach [ p |
			val prop = p.definePropertie
			if(prop !== null)
				smClass.features += prop
		]

		defineVectors(flow, smClass)

		if (flow.timed) {
			defineTimingFields(flow, smClass)
			smClass.features += defineTimerServiceSetter
			smClass.features += flow.defineRaiseTimeEvent
		}

	}

	def definePropertie(Property p) {
		if (p.type instanceof ComplexType)
			_part(p.name, p.type) => [
				generalProperties(p)
			]
		else
			_variable(p.name, p.type) => [
				generalProperties(p)
				generateDefinitionWith[variableDeclarationCode]
			]
	}

	def generalProperties(Property it, Property source) {
		it => [
			_internallyDefinedType
			traceOrigin(source)
			documentation(source.documentation)
			_private
			const = false
			static = false
			initialValue = source.initialValue.copy
			generateDeclarationWith[variableDeclarationCode]
		]
	}

	def defineTimingFields(ExecutionFlow flow, ComplexType clazz) {
		flow.statechart.createTypeDescription
		createVirtualTimerInterface
		
		flow.addTimerServiceMember(clazz)
		flow.addTimeEventsMember(clazz)		
	}
	
	def addTimerServiceMember(ExecutionFlow flow, ComplexType clazz){
		val timerServiceVariable = timerServiceVariable => [_internallyDefinedType]
		clazz.features += 
			if(timerServiceVariable.eContainer !== null)
				timerServiceVariable.copy
			else timerServiceVariable
	}
	
	def addTimeEventsMember(ExecutionFlow flow, ComplexType clazz){
		val timeEventsVariable = 
		timeEventsVariable(flow, flow.timeEvents.size) => [
			traceOrigin(flow.timeEvents)
			_internallyDefinedType
		]
		clazz.features += 
			if(timeEventsVariable.eContainer !== null)
				timeEventsVariable.copy
			else timeEventsVariable
	}

	def defineRaiseTimeEvent(ExecutionFlow flow) {
		val method = _op(raiseTimeEvent, _void) => [
			val param = createParameter => [
				name = "eventID"
				typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = _integer
				]
			]
			parameters += param
			// documentation('''Function declaration for operation«od.name» of «od.scope.scopeDescription».''')
			_public
			static = false
			
			implementation = _block() => [
				if(flow.requiresIncomingEventQueue){
					expressions += flow.queueTimeEvent(flow.setTimeEventTrue(param))
				} else
					expressions += flow.setTimeEventTrue(param)
				if(flow.isEventDriven)
					expressions += flow.stateMachineClass.runCycle._call
			]

			generateDefinitionWith[ methodDefinitionCode ]
		]
		return method
	}
	
	def protected setTimeEventTrue(ExecutionFlow flow, Parameter param){
		timeEventsVariable(flow, flow.timeEvents.size)._ref_array(param._ref)._assign(_true)
		//timeEventsVariable(flow.timeEvents.size)._ref._with(param._ref)._assign(_true)
	}
	
	//TODO: Implement this properly for generic purpose
	def protected Expression queueTimeEvent(ExecutionFlow flow, AssignmentExpression assignExpr){
		assignExpr
	}

	def void defineVectors(ExecutionFlow flow, ComplexType clazz) {
		clazz.features += _variable(orthogonalStatesConst.toFirstUpper, _integer) => [
			_internallyDefinedType
			documentation(
				"the maximum number of orthogonal states defines the dimension of the state configuration vector.")
			_private
			const = true
			static = true
			initialValue = flow.stateVector.size._value
			generateDeclarationWith[variableDeclarationCode]
		]

		clazz.features += _variable(
			stateConfVector.toString,
			createArrayTypeSpecifier => [
				type = flow.stateEnum
				size = flow.stateVector.size
			]
		) => [
			_internallyDefinedType
			_private
			const = false
			static = false
			initialValue = flow.stateVector.size._value
			generateDeclarationWith[variableDeclarationCode]
		]

		if (flow.hasHistory) {

			clazz.features += _variable(
				"historyVector",
				createArrayTypeSpecifier => [
					type = flow.stateEnum
					size = flow.historyVector.size
				]
			) => [
				_internallyDefinedType
				traceOrigin(flow.historyVector)
				_private
				const = false
				static = false
				initialValue = flow.historyVector.size._value
				generateDeclarationWith[variableDeclarationCode]
			]

			clazz.features += _variable(historyStatesConst, _integer) => [
				_internallyDefinedType
				documentation("dimension of the state configuration vector for history states")
				_private
				const = true
				static = true
				initialValue = flow.historyVector.size._value
				generateDeclarationWith[variableDeclarationCode]
			]
		}

	}

}
