/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.extensions

import com.google.inject.Inject
import com.google.inject.Provider
import com.yakindu.sct.generator.core.execution.FlowOptimizerFactory
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.transformation.IModelSequencer
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.StatechartUtil

/**
 * @author Axel Terfloth - Initial contribution.
 */
class CodeModelGeneratorExtension {
	
	@Inject Provider<IModelSequencer> sequencerProvider;
	@Inject protected extension ICodeModel
	@Inject protected extension StatechartUtil
	@Inject protected extension SExecExtensions
	@Inject FlowOptimizerFactory optimizerFactory;
	
	def defineClass(ExecutionFlow it, GeneratorEntry entry){
		extension val optimizer = optimizerFactory.create(entry);

		defineImplementationClass
		
		flow.statechart.referencedStatecharts.forEach[ 
			extension val sequencer = sequencerProvider.get
			
			transform
				.optimize
		]
	}
	
	def transform(Statechart it, GeneratorEntry entry){
		extension val optimizer = optimizerFactory.create(entry);
		extension val sequencer = sequencerProvider.get
		
		val flow = it.transform.optimize
		
		return flow
	}
	
	
}