/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.filesystem

import com.google.inject.Inject
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess.*

class OutputConfigProvider {

	@Inject protected extension ICoreLibraryHelper

	def getLibraryOutputConfig(GeneratorEntry entry) {
		if (entry.libraryTargetFolderValue !== null) {
			return LIBRARY_TARGET_FOLDER_OUTPUT
		}
		return entry.apiOutputConfig
	}

	def getApiOutputConfig(GeneratorEntry entry) {
		if (entry.apiTargetFolderValue !== null) {
			return API_TARGET_FOLDER_OUTPUT
		}
		return entry.defaultOutputConfig
	}
	
	
	def getDefaultOutputConfig(GeneratorEntry entry) {
		DEFAULT_OUTPUT
	}
	
}
