package com.yakindu.sct.generator.core.library

import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.*
import com.yakindu.sct.model.sgen.FeatureParameterValue

class CoreGenmodelEntries {
	
	def protected getLicenseFeature(GeneratorEntry it) {
		getFeatureConfiguration(LICENSE_HEADER)
	}
	
	def protected FeatureParameterValue getLicenseTextParameter(GeneratorEntry it) {
		licenseFeature?.getParameterValue(LICENSE_TEXT)
	}
	
	def protected getDebugFeatureParameter(GeneratorEntry it) {
		getFeatureConfiguration(DEBUG_FEATURE)
	}
	
	def getLicenseText(GeneratorEntry it) {
		if (licenseTextParameter !== null) {
			if(licenseTextParameter.stringValue.blank)
				return ""
			else
				return "/* " + licenseTextParameter.stringValue.trim + " */"
		}
		return LICENSE_STANDARD_TEXT
	}
	
	def String getLibraryPackage(GeneratorEntry it) {}
	
}