/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.submodules.lifecycle

import com.google.inject.Inject
import com.yakindu.base.types.Operation
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.concepts.EnterMethod
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.concepts.ExitMethod
import com.yakindu.sct.model.sexec.concepts.InitializedCheck
import com.yakindu.sct.model.sexec.concepts.StateMachineBehaviorConcept

/**
 * Instances of this class dispatches the generation of named sequences representing state machine concepts 
 * to specific code generator modules.
 * 
 * @author aterfloth 
 */
class NamedConceptSequenceCodeDispatcher implements NamedConceptSequenceCode {
	
	@Inject extension InitializedCheckCode
	@Inject extension EventCode
	@Inject extension TraceCode
	
	@Inject extension StateMachineBehaviorConcept
	 
	override stateMachineConceptCode(ExecutionFlow flow, Sequence s) {
		switch (s.name) {
			case EventProcessing.CLEAR_EVENT:
				return flow.eventClearCode(s.expression)
			case EventProcessing.MOVE_EVENT:
				return flow.eventMoveCode(s.expression, s.getExpression(1))
			case EventProcessing.NEXT_EVENT:
				return flow.eventNextCode
			case EnterMethod.TRACE_ENTER:
				return flow.traceEnterCode
			case ExitMethod.TRACE_EXIT:
				return flow.traceExitCode
			case InitializedCheck.INIT_CHECK :
				return flow.initializedCheckCode
			default : 
				return ''''''
		}		
	}
	
	override stateMachineConceptCode(ExecutionFlow flow, Operation s) {
		switch (s.name) {
			case EventProcessing.CLEAR_EVENT:
				return flow.eventClearCode(s.implementation)
			case EventProcessing.NEXT_EVENT:
				return flow.getNextEventCode
			default : 
				return '''// unknown concept sequence : «s.name»'''
		}
	}
	
}