/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.emf.ecore.util.EcoreUtil
import com.yakindu.base.types.Event
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import org.eclipse.emf.ecore.EObject

/**
 * This class defines the general concept of buffer events. Such events are used in event buffers. 
 * 
 * @author aterfloth
 */
@Singleton
class BufferEvent {
	
	public static String BUFFER_EVENT_ANNOTATION = "__buffer_event__"
	
	extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject extension TypeBuilder

		
	def create tFactory.createEvent createBufferEvent(Event bufferedEvent) {

		name = bufferedEvent.name
		direction = bufferedEvent.direction
		typeSpecifier = EcoreUtil.copy(bufferedEvent.typeSpecifier)
		if ( type !== null && type != _void ) _meta(_variable("value", type))
		_annotate(BUFFER_EVENT_ANNOTATION)
	}
	
	
	def dispatch isBufferEvent(Event it){
		annotations.exists[ a | a.type.name == BUFFER_EVENT_ANNOTATION]		
	}
	
	def dispatch isBufferEvent(EObject it){
		false
	}
	
}