/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration
import com.yakindu.sct.model.sgraph.Scope

/**
 * This class defines the concept of an event queue which can be applied to event driven state machines.
 * It defines extension methods that should be used to implement a code generator for event queues.
 * 
 * It currently define any types or statechart members.  
 * 
 * @author aterfloth
 */

class EventQueue {

	@Inject protected extension SExecExtensions
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension SubMachine
	@Inject protected IFlowConfiguration config

	def boolean requiresEventQueue(ExecutionFlow it) {
		requiresInternalEventQueue || requiresIncomingEventQueue
	}
	//TODO: Maybe this should not be here but in a more common place
	def boolean isEventDriven(ExecutionFlow flow) {
		config.isEventDriven
	}
	
	def boolean requiresIncomingEventQueue(ExecutionFlow it) {
		config.isEventDriven && (hasIncomingEvents || hasReferencedSubmachine) && config.applyIncomingEventQueue
	}

	def requiresInternalEventQueue(ExecutionFlow it) {
		config.isEventDriven && hasLocalEvents
	}
	
	def boolean isQueued(Event it) {
		config.isEventDriven && ((isLocalEvent && config.applyInternalEventQueue) || (isInEvent && config.applyIncomingEventQueue) || (isShadowEvent))
	} 
	
	def boolean hasQueuedEvents(ExecutionFlow it) {
		!queuedEvents.empty
	}

	def getQueuedEvents(ExecutionFlow it) {
		it.allEvents.filter[isQueued]
	}
	
	def getQueuedEvents(Scope it) {
		it.events.filter[isQueued]
	}
	
	
	def withValue(Iterable<Event> it) {
		filter[ e | e.hasValue]
	}
	
	def withoutValue(Iterable<Event> it) {
		filter[ e | ! e.hasValue]
	}
	
	def <T> exist(Iterable<T> it) {
		! empty
	}
	
}