package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * A state machine can be configured to be haltable. A haltable state machine provides 
 * a halt() method. if that method is called any ongoing processing will be terminated and the 
 * state machine enters a halted state. if a state machine is halted no further processing is possible.
 */
class HaltBehavior {
	
	
	@Inject extension TypeBuilder
	@Inject extension ExpressionBuilder
	@Inject extension Documentation
	@Inject extension StatechartAnnotations
	
	public static val String HALTED    = "halted"
	public static val String HALT      = "halt"
	public static val String IS_HALTED = "isHalted"


	def void defineFeatures (ExecutionFlow it) {
		if (appliesHaltBehavior) {
			defineHaltedProperty
			defineHalt
			defineIsHalted
		}
	}


	def _andIsNotHalted(Expression condition, ExecutionFlow it) {
		if (appliesHaltBehavior)
			condition._and( _not(haltedProperty._ref))
		else
			condition
	}
	
	def _orIsHalted(Expression condition, ExecutionFlow it) {
		if (appliesHaltBehavior)
			condition._or( haltedProperty._ref )
		else
			condition
	}
	
	def protected defineHaltedProperty(ExecutionFlow it) {
	
		it.features += _variable(HALTED, _boolean, _false) => [
			_synthetic
		]
	}
	
	def Property haltedProperty(ExecutionFlow it) {
		features.filter(Property).filter( m | m.name == HaltBehavior.HALTED).head
	}


	def protected defineHalt(ExecutionFlow it) {
	
		it.features += _op(HALT) => [ m |
			m.documentation(
				"Can be called by the client code to halt the state machine. "
				+ "A halted state machine is not reactive anymore. ")
			m._public
			m._type(_void)
			m.implementation = _block (
				haltedProperty._ref._assign(_true)
			)
		]
	}

	def Operation halt(ExecutionFlow it) {
		features.filter( typeof(Operation) ).filter( m | m.name == HALT).head		
	}

	def hasHalt(ExecutionFlow it) {
		halt !== null		
	}


	def protected defineIsHalted(ExecutionFlow it) {
	
		it.features += _op(IS_HALTED) => [ m |
			m.documentation("Returns true if the state machine is halted. " )
			m._public
			m._type(_boolean)
			m.implementation = _block (
				_return( haltedProperty._ref )
			)
		]
	}

	def Operation isHalted(ExecutionFlow it) {
		features.filter( typeof(Operation) ).filter( m | m.name == IS_HALTED).head		
	}
	
	def hasIsHalted(ExecutionFlow it) {
		isHalted !== null		
	}
	

	def appliesHaltBehavior(ExecutionFlow it) {
		(it.sourceElement as Statechart).isHaltable
	}
	
}