/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.itemis.create.base.model.bindings.OutProperty
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.google.inject.Inject
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.google.inject.Singleton

/**
 * Specialization of the OutPorperty concept for execution flows.
 * All variable definitions will be handled.
 * 
 * @author axel terfloth
 */
@Singleton
class SexecOutProperty extends OutProperty {
	
	@Inject protected extension SExecExtensions
	
	def synchronized void defineFeatures(ExecutionFlow it) {
		it.allVariableDefinitions.forEach[defineFeatures]
	}
	
}