/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.extensions

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.Call
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionNode
import com.yakindu.sct.model.sexec.ExecutionRegion
import com.yakindu.sct.model.sexec.ExecutionScope
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Reaction
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.ImportScope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.ArrayList
import java.util.LinkedList
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

@Singleton
class SExecExtensions {
	@Inject extension OriginTracing
	@Inject extension ShadowMemberScope
	
	
	def boolean exists(Object o) {
		o !== null
	}
	
	def <T extends EObject> T eContainerOfType(EObject eObject, Class<T> type) {
		EcoreUtil2.getContainerOfType(eObject, type)
	}
	
	def isDefaultInterface(Scope scope) {
		switch scope {
			InterfaceScope: scope.name === null || scope.name.empty
			default: false
		}
	}
	
	def ExecutionFlow flow(EObject it){
		eContainerOfType(ExecutionFlow)
	}
	
	def dispatch Statechart statechart(ExecutionFlow it) {
		sourceElement as Statechart
	}
	
	def dispatch Statechart statechart(EObject it) {
		if(eContainerOfType(Statechart) !== null)
			eContainerOfType(Statechart)
		else if(flow !== null)
			flow.statechart
	}
	
	def scope(EObject it) {
		var container = eContainer
		if (container instanceof ComplexType){
			val origin = it.originTraces.head
			if(origin instanceof Declaration){
				container = origin.eContainer
			}
		}
		if (container instanceof Scope) container
		else null
	}
	
	def Parameter param(Operation it, String name) {
		parameters.filter[p|p.name == name].head
	}
	
	def dispatch defaultInterfaceName(Void it) { "" }
	def dispatch defaultInterfaceName(Scope it) { "" }
	def dispatch defaultInterfaceName(InternalScope it) { "internal" }
	def dispatch defaultInterfaceName(InterfaceScope it) { name ?: "" }
	
	def dispatch scopeDescription(Scope it) '''scope'''

	def dispatch scopeDescription(InterfaceScope it) '''«IF name.nullOrEmpty»default interface scope«ELSE»interface scope '«name»'«ENDIF»'''

	def dispatch scopeDescription(InternalScope it) '''internal scope'''
	
	def isNamedScope(Scope it) {
		switch it {
			InterfaceScope: return name !== null
			InternalScope: return false
		}
	}
	
	def isInternalScope(Scope it) {
		it instanceof InternalScope
	}
	
	def InterfaceScope getInterfaceScope(EObject it) {
		eContainerOfType(InterfaceScope)
	}
	
	def isInNamedInterface(EObject it) {
		!interfaceScope?.name.nullOrEmpty
	}
	
	def operations(ExecutionFlow it) {
		scopes.map[operations].flatten
	}
	
	def Scope getTimeEventScope(ExecutionFlow it) {
		return 	scopes.filter[declarations.filter(TimeEvent).size > 0].head
	}
	
	def isTimed (ExecutionFlow it) {
		if(it === null) false
		else !timeEvents.empty
	}
	
	def getStatechartScopes(ExecutionFlow it) {
		scopes.filter(StatechartScope)
	}
	
	def operations(Scope it) {
		declarations.filter(OperationDefinition);
	}
	
	def hasOperations(Scope it) {
		!operations.isEmpty;
	}
	
	def indexOf(TimeEvent it) {
		scope.declarations.filter(TimeEvent).toList.indexOf(it);
	}
	
	def getInterfaces(ExecutionFlow it) {
		scopes.filter(StatechartScope).filter[!(it instanceof ImportScope)]
	}
	
	def getNamedInterfaces(ExecutionFlow it) {
		scopes.filter(InterfaceScope).filter[name !== null]
	}
	
	def getUnnamedInterfaces(ExecutionFlow it) {
		scopes.filter(InterfaceScope).filter[name === null]
	}
	
	def getNamedInterfacesAndInternal(ExecutionFlow it) {
		return namedInterfaces + scopes.filter(InternalScope)
	}
	
	def getUnnamedInterfacesAndInternal(ExecutionFlow it) {
		return unnamedInterfaces + scopes.filter(InternalScope)
	}
	
	def getProperties(ExecutionFlow it) {
		features.filter(Property)
	}
	
	def getConstants(ExecutionFlow it) {
		scopes.map[declarations.filter(VariableDefinition).filter[const]].flatten.toList
	}
	
	def hasOperationCallbacks (ExecutionFlow it){
		scopes.filter[declarations.filter(OperationDefinition).size > 0].size > 0
	}
	
	def getTimeEvents(ExecutionFlow it) {
		scopes.map[declarations.filter(TimeEvent)].flatten.toList
	}
	
	def getTimeEvent(ExecutionFlow flow, String timeEventName) {
		flow.timeEvents.findFirst[name.compareTo(timeEventName) == 0]
	}
	
	def dispatch hasValue (Event it) {
		type !== null && type.name != 'void'
	}
	
	def hasMetaValue(Declaration e) {
		!e.metaFeatures.nullOrEmpty
	}
	
	def dispatch hasValue(Object it) {
		false;
	}
	
	def boolean hasInternalScope(ExecutionFlow it) {
		internalScope !== null;
	}
	
	def getInternalScope(ExecutionFlow it) {
		it.scopes.filter(InternalScope).filter[!isShadowMemberScope].head
	}
	
	def hasHistory(ExecutionFlow it) {
		historyVector !== null && historyVector.size > 0;
	}
	
	def hasOutgoingEvents(Scope it) {
		!outgoingEvents.empty
	}
	
	def hasOutgoingEvents(ExecutionFlow it) {
		!outgoingEvents.empty
	}
	
	def getInternalScopeEvents(ExecutionFlow flow) {
		flow.internalScopes.map[eventDefinitions].flatten
	}

	def getInternalScopeVariables(ExecutionFlow flow) {
		flow.internalScopes.map[variableDefinitions].flatten
	}
	
	def getEventDefinitions(Scope scope) {
		scope.declarations.filter(EventDefinition)
	}
	
	def eventAndVariableDefinitions(Scope scope) {
		scope.declarations.filter[ e | e instanceof EventDefinition || e instanceof VariableDefinition]
	}
	
	def boolean hasEvents(Scope it) {
		return !eventDefinitions.empty
	}
	
	def boolean hasEvents(ExecutionFlow it) {
		return !getAllEventDefinitions.empty
	}
	
	def boolean hasIncomingEvents(ExecutionFlow it) {
		hasInEvents || timeEvents.size > 0 	
	}
	
	def getAllVariableDefinitions(ExecutionFlow it) {
		return scopes.map[variableDefinitions].flatten
	}
	
	
	def getAllEventDefinitions(ExecutionFlow it) {
		return scopes.map[eventDefinitions].flatten
	}

	def getAllEvents(ExecutionFlow it) {
		return scopes.map[getEvents].flatten
	}
	
	def getAllEventAndVariables(ExecutionFlow it) {
		return scopes.map[eventAndVariableDefinitions].flatten
	}
	
	def hasLocalEvents(ExecutionFlow it) {
		return hasInternalScope && !internalScope.localEvents.empty
	}
	
	def hasLocalEventsWithValue(ExecutionFlow it) {
		return hasInternalScope && !internalScope.localEvents.filter[hasValue].empty
	}
	
	def getOutgoingEvents(Scope it) {
		eventDefinitions.filter[isOutEvent]
	}
	
	def Iterable<EventDefinition> getOutgoingEvents(ExecutionFlow it) {
		scopes.map[outgoingEvents].flatten
	}
	
	def hasIncomingEvents(Scope it) {
		!incomingEvents.empty
	}
	
	def hasInEvents(ExecutionFlow it) {
		!getIncomingEvents.empty
	}
	
	def hasIncomingEventsWithValue(Scope it) {
		!incomingEvents.filter[hasValue].empty
	}
	
	def hasIncomingEventsWithValue(ExecutionFlow it) {
		!interfaces.filter[hasIncomingEventsWithValue].empty
	}
		
	def List<EventDefinition> getIncomingEvents(Scope it) {
		declarations.filter(EventDefinition).filter[isInEvent].toList
	}
	
	def List<EventDefinition> getIncomingEvents(ExecutionFlow it) {
		interfaces.map[incomingEvents].flatten.toList
	}
	
	def List<Event> getSubmachineEvents(ExecutionFlow it) {
		features.filter(Event).toList
	}
	
	def getIncomingEventsAsTypedDeclaration(ExecutionFlow it) {
		interfaces.map[incomingEvents].flatten.filter(TypedDeclaration).toList
	}
	
	def List<EventDefinition> getLocalEvents(Scope it) {
		if(it === null) return emptyList
		declarations.filter(EventDefinition).filter[isLocalEvent].toList
	}
	
	def List<EventDefinition> getLocalEvents(ExecutionFlow it) {
		internalScope.localEvents
	}
	
	def boolean isLocalEvent(Event it) {
		direction === Direction::LOCAL
	}
	
	def boolean isOutEvent(Event it) {
		direction === Direction::OUT
	}
	
	def boolean isInEvent(Event it) {
		direction === Direction::IN
	}
	
	def getInterfaceScopes(ExecutionFlow it) {
		scopes.filter(InterfaceScope)
	}
	
	def getNamedInterfaceScopes(ExecutionFlow it) {
		scopes.filter(InterfaceScope).filter[!name.nullOrEmpty]
	}

	def Iterable<InternalScope> getInternalScopes(ExecutionFlow it) {
		return scopes.filter(InternalScope)
	}
	
	def getDefaultScope(ExecutionFlow it) {
		interfaceScopes.filter[isDefaultInterface].head
	}
	
	def getVariableDefinitions(Scope it) {
		declarations.filter(VariableDefinition)
	} 
	
	def getProperties(Scope it) {
		declarations.filter(Property)
	} 
	
	def dispatch definition(ElementReferenceExpression it) {
		if (reference instanceof Declaration) reference as Declaration
	}
	def dispatch definition(FeatureCall it) {
		feature as Declaration
	}
	
	def dispatch definition(EObject it){
		null
	}
	
	def needsAssignMethod(Property property) {
		property.flow.eAllContents.filter(AssignmentExpression)
			.filter[eContainer instanceof Expression 
				&& varRef.definition instanceof Property
			]
			.findFirst[(varRef.definition as Property).equals(property)] !== null
	}
	
	def Event event(Declaration it) {
		if (it instanceof Event) it else null 	
	}
	
	
	def List<ExecutionScope> superScopes(ExecutionScope it) {
		superScope.superScopeList
	}

	def List<ExecutionScope> superScopeList(ExecutionScope it) {
		if(superScope === null) return new ArrayList<ExecutionScope>()
		
		return it.superScope.superScopeList => [ l |
			l.add(0, it)
		]
	}
	
	
	def dispatch List<ExecutionState> subStates(ExecutionState it) {
		subScopes.fold(new ArrayList<ExecutionState>, 
			[a, s | 
				if ( s instanceof ExecutionState ) {
					a.add(s)
				} else {
					a.addAll(s.subStates)				
				}
				a
			]
		)
	} 
	
	def dispatch List<ExecutionState> subStates(ExecutionRegion it) {
		subScopes.fold(new ArrayList<ExecutionState>, 
			[a, s | 
				a.add(s as ExecutionState)
				a.addAll(s.subStates)
				a
			]
		)
	} 
	
	def dispatch List<ExecutionState> subStates(ExecutionScope it) {
		return new ArrayList<ExecutionState>()
	}
	
	def referencedChecks(ExecutionNode it) {
		reactions.filter( r | r.check !== null && r.check.refs.size > 0).map[it.check]
	}

	def referencedEffects(ExecutionNode it) {
		reactions.filter( r | r.effect !== null && r.effect.caller.size > 0).map( r | r.effect )
	}
	
	def List<Step> checkFunctions(ExecutionFlow it) {
		val funcs = new ArrayList<Step>()
		funcs += referencedChecks
		states.forEach( s | funcs += s.referencedChecks )
		nodes.forEach( n | funcs += n.referencedChecks )
		funcs
	}
	 
	def List<Step> effectFunctions(ExecutionFlow it) {
		val funcs = new ArrayList<Step>()
		funcs += referencedEffects.filter[reachable]
		states.forEach( s | funcs += s.referencedEffects.filter[reachable] )
		nodes.forEach( n | funcs += n.referencedEffects.filter[reachable] )
		return funcs
	}
	 
	def List<Step> entryActionFunctions(ExecutionFlow it) {
		val funcs = new ArrayList<Step>()
		if (entryAction.reachable) funcs.add(entryAction) 
		states.forEach( s | if (s.entryAction.reachable) funcs += s.entryAction )
		return funcs
	}
	
	def List<Step> exitActionFunctions(ExecutionFlow it) {
		val funcs = new ArrayList<Step>()
		if (exitAction.reachable) funcs.add(exitAction) 
		states.forEach( s | if (s.exitAction.reachable) funcs += s.exitAction )
		return funcs
	}


	/* Returns the function Sequence which contains the Call.*/
	def callerFunction(Call it) {
		return it.ownerFunction
	}
	
	def dispatch Sequence ownerFunction(Sequence it){
		
		if ( (eContainer instanceof ExecutionNode) || (eContainer instanceof ExecutionScope) || (eContainer instanceof Reaction))  {
			return it	
		} else 
			return eContainer?.ownerFunction
	}
	
	def dispatch Sequence ownerFunction(EObject it){
		
		if (eContainer === null) return null
		
		return eContainer.ownerFunction
	}
	
	def dispatch Sequence ownerFunction(Method it){
		return null
	}
	
	
	def dispatch Method ownerMethod(EObject it){
		if (eContainer === null) {
			return null	
		} else {
			return eContainer.ownerMethod
		}
	}
	
	def dispatch Method ownerMethod(ExecutionNode it){
		return null
	}
	
	def dispatch Method ownerMethod(ExecutionScope it){
		return null
	}
	
	def dispatch Method ownerMethod(Method it){
		return it
	}
	
	
	/** Checks if a step is reachable.   */
	def boolean isReachable(Step it) {
		if ( it === null ) return false
		
		for( c : it.caller ) {
			if (c.ownerMethod !== null) return true
			val f = c.ownerFunction
			if (f !== null ) {
				if (f.eContainer instanceof ExecutionFlow ) return true
				if (f.reachable) return true	
			}
		}
		
		return false
	}
	
	def List<Sequence> reachable(List<Sequence> it) {
		filter( s | s.reachable ).toList
	}
	
	
	/**
	 * Checks if a step is called or not.
	 */
	def isCalled(Step it) { it !== null && caller.size > 0 }
	
	
	/**
	 * Returns a list of all steps that are called. 
	 */
	def List<Sequence> called(List<Sequence> it) {
		filter( s | s.called ).toList
	}
	
	 
	def List<Step> enterSequenceFunctions(ExecutionFlow it) {
		val funcs = new ArrayList<Step>()
		funcs.addAll(enterSequences.reachable) 
		states.forEach( s | funcs += s.enterSequences.reachable )
		regions.forEach( s | {
			funcs += s.enterSequences.reachable
			if (s.deepEnterSequence.reachable) funcs += s.deepEnterSequence
			if (s.shallowEnterSequence.reachable) funcs += s.shallowEnterSequence
		})
		return funcs
	}
	 
	def List<Step> exitSequenceFunctions(ExecutionFlow it) {
		val funcs = new ArrayList<Step>()
		if (exitSequence.reachable) funcs.add(exitSequence) 
		states.forEach( s | if (s.exitSequence.reachable) funcs += s.exitSequence )
		regions.forEach( s | if (s.exitSequence.reachable
		) funcs += s.exitSequence )
		return funcs
	}
	 
	def List<Method> reactMethods(ExecutionFlow it) {
		new ArrayList<Method>() => [ l | 
			l.add(it.reactMethod()) 
			l.addAll(it.states.map( s | s.reactMethod))
			l.removeIf( m | m === null)
		] 	
	}
	
	def Method reactMethod(ExecutionNode it) {
		features.filter( typeof(Method) ).filter( m | m.name == "react").head
	}
	
	
	def methods(ExecutionFlow it) {
		features.filter(Method).filter( m | m !== reactMethod)
	}
		

	/** includes Operations and sexec-Method instances defined for the execution flow. */	
	def allMethods(ExecutionFlow it) {
		features.filter(Operation).filter( m | m !== reactMethod)
	}
		
	def List<Step> reactFunctions(ExecutionFlow it) {
		val funcs = new ArrayList<Step>()
		if (reactSequence.reachable) funcs.add(reactSequence) 
		states.forEach( s | if (s.reactSequence.reachable) funcs += s.reactSequence )
		nodes.forEach( s | if (s.reactSequence.reachable) funcs += s.reactSequence )
		return funcs
	}
	
	def dispatch List<ExecutionState> collectLeafStates(ExecutionState state, List<ExecutionState> leafStates) {
		if ( state.isLeaf ) 
			leafStates += state
		else {
			for ( r : state.subScopes ) {
				r.collectLeafStates(leafStates)
			}
		}
		return leafStates	
	}
	
	def dispatch List<ExecutionState> collectLeafStates(ExecutionRegion region, List<ExecutionState> leafStates) {
		for ( r : region.subScopes ) {
			r.collectLeafStates(leafStates)
		}
		
		return leafStates	
	}
	
	def directlyContainedLeafState(ExecutionState it, ExecutionState parent) {
		sourceElement?.eContainer?.eContainer === parent.sourceElement	
	}
	
	
	
	def dispatch Reaction reaction(Check it) { eContainer as Reaction }
	def dispatch Reaction reaction(EObject it) { eContainer?.reaction }
	def dispatch Reaction reaction(Reaction it) { it }

	def isEntryAction(Step it) { eContainer.isEntryAction(it) }
	def dispatch isEntryAction(ExecutionFlow it, Step s) { entryAction == s }
	def dispatch isEntryAction(ExecutionState it, Step s) { entryAction == s }
	def dispatch isEntryAction(EObject it, Step s) { false }
	
	def isExitAction(Step it) { eContainer.isExitAction(it) }
	def dispatch isExitAction(ExecutionFlow it, Step s) { exitAction == s }
	def dispatch isExitAction(ExecutionState it, Step s) { exitAction == s }
	def dispatch isExitAction(EObject it, Step s) { false }
	
	def isEffect(Step it) { eContainer.isEffect(it) }
	def dispatch isEffect(Reaction it, Step s) { effect == s }
	def dispatch isEffect(EObject it, Step s) { false }
	
	def isEnterSequence(Step it) { eContainer.isEnterSequence(it) }
	def dispatch isEnterSequence(ExecutionScope it, Step s) { enterSequences.contains(s) }
	def dispatch isEnterSequence(EObject it, Step s) { false }
	
	def isDeepEnterSequence(Step it) { eContainer.isDeepEnterSequence(it) }
	def dispatch isDeepEnterSequence(ExecutionRegion it, Step s) { deepEnterSequence == s }
	def dispatch isDeepEnterSequence(EObject it, Step s) { false }
	
	def isShallowEnterSequence(Step it) { eContainer.isShallowEnterSequence(it) }
	def dispatch isShallowEnterSequence(ExecutionRegion it, Step s) { shallowEnterSequence == s }
	def dispatch isShallowEnterSequence(EObject it, Step s) { false }

	def isExitSequence(Step it) { eContainer.isExitSequence(it) }
	def dispatch isExitSequence(ExecutionScope it, Step s) { exitSequence == s }
	def dispatch isExitSequence(EObject it, Step s) { false }
	
	def isReactSequence(Step it) { eContainer.isReactSequence(it) }
	def dispatch isReactSequence(ExecutionNode it, Step s) { reactSequence == s }
	def dispatch isReactSequence(EObject it, Step s) { false }
	
	def isCheckFunction(Step it) { it instanceof Check }
	
	
	
	/**
	 * Returns a step that mathes the given name.
	 */
	def Sequence byName(List<Sequence>steps, String name) {
		steps.filter(s | name.trim == s.name.trim ).head
	}

	/**
	 * Returns the default step that is the step without name or the name 'default'.
	 */
	def Sequence defaultSequence(List<Sequence>steps) {
		steps.filter(s | s.name === null || s.name.trim == "" ||  s.name.trim == "default" ).head
	}
	
	/**
	 * Tries to find the next super ExecutionScope from the eContainer hierarchy.
	 * 
	 * @return
	 * 		The super ExecutionScope or null
	 */
	def ExecutionScope parentExecutionScope(EObject it) {
		eContainerOfType(ExecutionScope)
	}
	
	/**
	 * Calculates the depth of a step within the ExecutionScope hierarchy. If the
	 * Step is directly below the ExecutionFlow it has a depth of 0.
	 * 
	 * @return
	 * 		The depth of the element
	 */
	def int getScopeDepth(Step it) {
		return parentExecutionScope.scopeDepth
	}
	
	/**
	 * Calculates the depth of a ExecutionScope.
	 * The ExecutionFlow has as root element a depth of 0.
	 * 
	 * * @return
	 * 		The depth of the element
	 */
	def int getScopeDepth(ExecutionScope it) {
		var scopeDepth = 0

		if (it instanceof ExecutionFlow) {
			return 0
		} else {
			scopeDepth = superScope.scopeDepth + 1
		}
		return scopeDepth
	}
	

	/**
	 * returns all functions of an ExecutionFlow.
	 */
	def List<Step> getAllFunctions(ExecutionFlow it) {
		var functions = new ArrayList<Step>
		functions.addAll(checkFunctions)
		functions.addAll(effectFunctions)
		functions.addAll(entryActionFunctions)
		functions.addAll(exitActionFunctions)
		functions.addAll(enterSequenceFunctions)
		functions.addAll(exitSequenceFunctions)
		functions.addAll(reactFunctions)
		return functions
	}
	
	
	def derivedComplexTypes(ExecutionFlow flow) {
		
		val types = new LinkedList<ComplexType> 
		flow.collectDerivedComplexTypes(types)
		return types
	}
	
	
	protected def LinkedList<ComplexType> collectDerivedComplexTypes(ComplexType it, LinkedList<ComplexType> types) {
		it.referencedComplexTypes.reverseView.forEach[ t | 
			if (!types.contains(t)) {
				types.push(t)
				t.collectDerivedComplexTypes(types)
			}
		]
		
		return types		
	} 
	
	def referencedComplexTypes(ComplexType it) {
		it	.features
			.filter(Property)
			.filter[typeSpecifier.type instanceof ComplexType]
			//Do not consider types that we define within a 'type library'
			.filter[!(eContainer instanceof com.yakindu.base.types.Package)]
			.map[typeSpecifier.type as ComplexType]
			.toList
	}
	
	def statevectorLastPosition(ExitState it){
		it.state.statevectorLastPosition
	}
	
	def statevectorFirstPosition(ExecutionState it){
		if(it.sourceElement instanceof State && !(it.sourceElement as State).isLeaf){
			EcoreUtil2.getContainerOfType(it, ExecutionState).stateVector.offset
		} else
			stateVector.offset
	}
	
	def statevectorLastPosition(ExecutionState it){
		stateVector.offset + stateVector.size - 1
	}
	
	def EObject flowOrStatechart(EObject it) {
		var EObject container = it.flow
		if (container === null) container = it.statechart
		return container
	}

}
