/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.extensions

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.StextFactory
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

@Singleton
class ShadowEventExtensions {

	@Inject extension ShadowMemberScope
	@Inject extension OriginTracing
	@Inject extension SExecExtensions
	@Inject extension ExpressionExtensions
	@Inject extension StatechartUtil
	@Inject extension TypeBuilder
	
	extension StextFactory = StextFactory.eINSTANCE

	def getShadowEvents(Property member) {
		member.flow.shadowEvents.filter[originTraces.contains(member)]
	}

	def getShadowEvent(Property member, Event outEvent) {
		member.shadowEvents.findFirst[originTraces.contains(outEvent)]
	}

	def getShadowEvents(ExecutionFlow it) {
		allEvents.filter(e | e.isShadowEvent)
	}
	
	def isShadowEvent(Event it){
		// in events in internal scope => must be a shadow event
		direction == Direction.IN && scope instanceof InternalScope
	}
	
	def getShadowEvents(StatechartScope it) {
		members.filter[scope.flow.shadowEvents.toList.contains(it)].filter(Event)
	}
	
	def getShadowEventsByScope(Property member) {
		member.shadowEvents.groupBy[originTraces.filter(Event).head.eContainer as InterfaceScope]
	}

	def getShadowEventName(FeatureCall fc) {
		fc.toCallStack.map[featureOrReference].filter(NamedElement).map[name].join("_")
	}
	
	def needsShadowEventMapping(Property member) {
		member.flow !== null && member.type.isOriginStatechart && !member.shadowEvents.nullOrEmpty
	}
	
	def getOutEvent(Event shadowEvent) {
		shadowEvent.originTraces.filter(Event).filter[direction == Direction.OUT].head
	}

	def create StextFactory.eINSTANCE.createEventDefinition createShadowEvent(String shadowEventName,
		EObject member, Event originEvent, ExecutionFlow flow) {

		name = shadowEventName
		direction = Direction.IN
		typeSpecifier = EcoreUtil.copy(originEvent.typeSpecifier)
		if ( type !== null && type != _void ) _meta(_variable("value", type))

		// trace to statechart event, not the one in the statechart type
		traceOrigin(originEvent.originTraces.filter(Event).head)
		// also trace to submachine member, so we can properly trace back in getShadowEvent(member, event)
		traceOrigin(member)

		flow.shadowMemberScope.members += it
	}
	
	//==========================================================================
	// Used for mapping own out events to local shadow events
	//
	
	def getLocalOutEventName(Event outEvent) {
		val scope = outEvent.eContainer as InterfaceScope
		"local_" + #[scope.name, outEvent.name].filterNull.join("_")
	}
	
	def getLocalOutEvent(Event outEvent) {
		outEvent.flow.localEvents.findFirst[originTraces.contains(outEvent)]
	}

	def create StextFactory.eINSTANCE.createEventDefinition createLocalOutEvent(String localEventName, Event originEvent, ExecutionFlow flow) {

		name = localEventName
		direction = Direction.LOCAL
		typeSpecifier = EcoreUtil.copy(originEvent.typeSpecifier)
		if ( type !== null && type != _void ) _meta(_variable("value", type))

		traceOrigin(originEvent)
		
		flow.getOrCreateInternalScope.members += it
	}
	
	def protected getOrCreateInternalScope(ExecutionFlow it) {
		if (!hasInternalScope) {
			scopes += createInternalScope
		}
		internalScope
	}
	
	def isLocalOutEvent(Event it) {
		direction == Direction.LOCAL 
		&& originTraces.filter(Event).filter[direction === Direction.OUT].head.exists
	}

}
