package com.yakindu.sct.model.sexec.extensions

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.LinkedList
import org.eclipse.emf.ecore.EObject

class StatemachineTypes {
	
	@Inject ITypeSystem typeSystem
	
	def declaredInternalStatemachineTypes(ExecutionFlow flow) {
		val allTypes = new LinkedList<ComplexType>
		val types = newLinkedHashSet
		flow.scopes.forEach[collectDeclaredInternalStatemachineTypes(allTypes)]
		allTypes.forEach[types.add(it)]
		return types
		
	}
	
	protected def LinkedList<ComplexType> collectDeclaredInternalStatemachineTypes(Scope it, LinkedList<ComplexType> types) {
		it.members.filter(VariableDefinition).filter(v | v.type.isInternalStatemachineType).map[type].filter(ComplexType)
		.forEach[t | 
			types.add(t)
			t.superTypes.map[type].filter(s | s.isInternalStatemachineType)
				.forEach[st | if(!types.contains(st)) types.push(st as ComplexType)]
		]
		return types		
	}
	
	def dispatch ComplexType getStatemachineType(ComplexType it) {
		typeSystem.getSuperTypes(it).filter(ComplexType).filter [
			name == "EventDrivenStatemachine" || name == "CycleBasedStatemachine"
		].head
	}

	dispatch def ComplexType getStatemachineType(TypedDeclaration it) {
		type.getStatemachineType
	}
		
	def isStatemachine(Type it) {
		statemachineType !== null	}

	
	def dispatch ComplexType getStatemachineType(Type it) {
		null
	}
	
	def dispatch boolean isInternalStatemachineType(ComplexType it){
		superTypes.map[type].filter(ComplexType).filter[name == "Statemachine"].head !== null || name == "Statemachine"
	}
	
	def dispatch boolean isInternalStatemachineType(EObject it){
		if(it instanceof ComplexType)
			return isInternalStatemachineType
		else
			false
	}
}