/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.naming.tree

import com.google.inject.Inject
import com.yakindu.base.types.TypesUtil
import java.util.List
import java.util.Map

/**
 * @author rbeckmann
 *
 */
class ShortStringUtils {
	
	@Inject protected extension TypesUtil
	
	def List<ShortString> getLongestElement(List<List<ShortString>> names) {
		names.sortBy[getLength].lastOrNull
	}
	
	def getLength(List<ShortString> list) {
		list.map[shortenedSize].reduce[a, b|a + b]
	}
	
	def int getMaxLength(List<List<ShortString>> names) {
		return names.map[getLength].max
	}
	
	def String join(List<ShortString> name) {
		val sb = new StringBuilder

		name.forEach[sb.append(toString)]

		sb.toString
	}
	
	def ShortString toShortString(StringTreeNode node, Map<StringTreeNode, ShortString> map) {
		if (!map.containsKey(node)) {
			map.put(node, new ShortString(node.data, node.getRoot.weight - node.weight + 1))
		}
		map.get(node)

	}
}