/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.naming.tree

import com.google.inject.Inject
import java.util.List
import java.util.Set
import org.eclipse.xtend.lib.annotations.Accessors

/**
 * @author rbeckmann
 *
 */
class TreeServiceNamesValidator {
	@Accessors protected List<List<ShortString>> names
	
	@Inject protected extension ShortStringUtils
	
	def boolean validate() {
		val Set<String> set = newHashSet

		if (names === null) {
			return false
		} else {
			for (name : names) {
				val s = name.join

				if (!set.add(s)) {
					return false
				}
			}
			return true
		}
	}
}