/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.transformation

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.DeclarationExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.ExecutionDebugging
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.SexecBuilder
import com.yakindu.sct.model.sexec.naming.DefaultNamingService
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Vertex
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.Set
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.xtext.EcoreUtil2

/**
 * This class declares and defines a corresponding evaluation method for each guard
 * The purpose of this modification is to enable logging, which is embadded in these guard evaluation functions
 * If the Debug Execution concept is disabled these methods are not declared nor defined
 * 
 * @author laszlo kovacs
 */
@Singleton
class GuardMapping {
	
	@Inject extension SexecElementMapping
	@Inject extension TypeBuilder
	@Inject extension SexecBuilder sexec
	@Inject extension SExecExtensions
	@Inject extension ExpressionBuilder 
	@Inject extension DefaultNamingService
	@Inject protected extension ExecutionDebugging
	
	def mapGuards(Statechart statechart, ExecutionFlow r){
		val allStates = statechart.eAllContents.filter(Vertex).toList
		allStates.map[outgoingTransitions].flatten.filter[trigger instanceof ReactionTrigger].map[trigger as ReactionTrigger].filter[guard !== null].forEach[ t |
			r.declareGuardMethod(t)
		]
	}
	
	def declareGuardMethod(ExecutionFlow node,ReactionTrigger t) {
		node => [
			features.add(t.defineGuardMethod)
		]
	}

	def create method: sexecFactory.createMethod defineGuardMethod(ReactionTrigger sc_Trigger) {
		
		// as we must never modify the scTrigger and its content we first copy it for embedding into the flow
		val flowGuardExpression = sc_Trigger.guard.expression.copy
		val containingState = EcoreUtil2.getContainerOfType(sc_Trigger, Vertex)
		val methodName = containingState.shortName.replace(containingState.statechart.name + "_","") + "_react_guard_" + containingState.outgoingTransitions.indexOf(sc_Trigger.eContainer)
		val loggerInstance = sc_Trigger.debugLogInstance
		
		val result = _variable("result", _boolean)
		val logs = loggerInstance.logFor(flowGuardExpression).expressions
		val logSeq = _sequence()
		logs.forEach[ e |
			logSeq.steps.add(e.copy._statement)
		]
		
		val Set<DeclarationExpression> locDeclExp = newLinkedHashSet
		
		flowGuardExpression.eAllContents.filter(ElementReferenceExpression).filter[reference instanceof VariableDefinition].forEach[ vdRef |
			val vd = vdRef.reference as VariableDefinition
			val vdLocal = _declare(_variable(vd.name + "_local", vd.type, vd._ref))
			EcoreUtil.replace(vdRef,vdLocal.declaration._ref)
			if(!locDeclExp.filter(DeclarationExpression).exists[e | e.declaration.name == vdLocal.declaration.name]){
				locDeclExp.add(vdLocal)
			}	
		]
		
		method.name = methodName
		method._type(_boolean)
		method => [
			body = _sequence(
				_sequence(locDeclExp.map[it._statement]),
				_local(result)._with(flowGuardExpression),
				sexec._if(result._ref)._then(
					logSeq		
				),
				_return(result._ref)._statement
			) => [comment = "transition guard evaluation."]
		]
	}
	
	def void cleanUp() {
		_createCache_defineGuardMethod.clear
	}
}