/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import com.google.inject.Singleton

/**
 * 
 * @author Jonathan Thoene - Adding of functions to generate mocking statements
 * 
 */
@Singleton
class CppStatementExtensions extends BaseStatementExtensions {
	@Inject extension CppExpressions
	@Inject extension CppMockingExtensions

	def dispatch generate(AssertionStatement it) {
		'''
			EXPECT_TRUE(«expression.code»)«IF !errorMsg.nullOrEmpty» << "«errorMsg»" «ENDIF»;
		'''
	}

	def dispatch generate(VerifyCalledStatement it) {
		'''«generateMockingStatement»'''
	}

	def dispatch generate(MockingStatement it) {
		'''«generateMockingStatement»'''
	}
}
